/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public class NativeImageConditionResolver
implements ConfigurationConditionResolver<ConfigurationCondition> {
    private final ImageClassLoader classLoader;
    private final ClassInitializationSupport classInitializationSupport;

    public NativeImageConditionResolver(ImageClassLoader classLoader, ClassInitializationSupport classInitializationSupport) {
        this.classLoader = classLoader;
        this.classInitializationSupport = classInitializationSupport;
    }

    @Override
    public TypeResult<ConfigurationCondition> resolveCondition(UnresolvedConfigurationCondition unresolvedCondition) {
        String canonicalizedName = ConfigurationTypeDescriptor.canonicalizeTypeName(unresolvedCondition.getTypeName());
        TypeResult<Class<?>> clazz = this.classLoader.findClass(canonicalizedName);
        return clazz.map(type -> {
            boolean runtimeChecked = !this.classInitializationSupport.isAlwaysReached((Class<?>)type) && unresolvedCondition.isRuntimeChecked();
            return ConfigurationCondition.create((Class)type, (boolean)runtimeChecked);
        });
    }

    @Override
    public ConfigurationCondition alwaysTrue() {
        return ConfigurationCondition.alwaysTrue();
    }
}

