/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import org.graalvm.collections.EconomicMap;

class ReduceImplicitExceptionStackTraceInformationPhase
extends BasePhase<LowTierContext> {
    private static final Map<ForeignCallDescriptor, ForeignCallDescriptor> optimizedCreateDescriptors = Map.ofEntries(Map.entry(ImplicitExceptions.CREATE_NULL_POINTER_EXCEPTION, ImplicitExceptions.CREATE_OPT_NULL_POINTER_EXCEPTION), Map.entry(ImplicitExceptions.CREATE_OUT_OF_BOUNDS_EXCEPTION, ImplicitExceptions.CREATE_OPT_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.CREATE_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION, ImplicitExceptions.CREATE_OPT_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.CREATE_CLASS_CAST_EXCEPTION, ImplicitExceptions.CREATE_OPT_CLASS_CAST_EXCEPTION), Map.entry(ImplicitExceptions.CREATE_ARRAY_STORE_EXCEPTION, ImplicitExceptions.CREATE_OPT_ARRAY_STORE_EXCEPTION), Map.entry(ImplicitExceptions.CREATE_INCOMPATIBLE_CLASS_CHANGE_ERROR, ImplicitExceptions.CREATE_OPT_INCOMPATIBLE_CLASS_CHANGE_ERROR), Map.entry(ImplicitExceptions.GET_CACHED_NULL_POINTER_EXCEPTION, ImplicitExceptions.GET_CACHED_NULL_POINTER_EXCEPTION), Map.entry(ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION, ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.GET_CACHED_CLASS_CAST_EXCEPTION, ImplicitExceptions.GET_CACHED_CLASS_CAST_EXCEPTION), Map.entry(ImplicitExceptions.GET_CACHED_ARRAY_STORE_EXCEPTION, ImplicitExceptions.GET_CACHED_ARRAY_STORE_EXCEPTION), Map.entry(ImplicitExceptions.GET_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR, ImplicitExceptions.GET_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR));
    private static final Map<ForeignCallDescriptor, ForeignCallDescriptor> optimizedThrowDescriptors = Map.ofEntries(Map.entry(ImplicitExceptions.THROW_NEW_NULL_POINTER_EXCEPTION, ImplicitExceptions.THROW_OPT_NULL_POINTER_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS, ImplicitExceptions.THROW_OPT_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION, ImplicitExceptions.THROW_OPT_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS, ImplicitExceptions.THROW_OPT_CLASS_CAST_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION, ImplicitExceptions.THROW_OPT_CLASS_CAST_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS, ImplicitExceptions.THROW_OPT_ARRAY_STORE_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION, ImplicitExceptions.THROW_OPT_ARRAY_STORE_EXCEPTION), Map.entry(ImplicitExceptions.THROW_NEW_INCOMPATIBLE_CLASS_CHANGE_ERROR, ImplicitExceptions.THROW_OPT_INCOMPATIBLE_CLASS_CHANGE_ERROR), Map.entry(ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION, ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION), Map.entry(ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION, ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION), Map.entry(ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION, ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION), Map.entry(ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION, ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION), Map.entry(ImplicitExceptions.THROW_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR, ImplicitExceptions.THROW_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR));

    ReduceImplicitExceptionStackTraceInformationPhase() {
    }

    protected void run(StructuredGraph graph, LowTierContext context) {
        EconomicMap optimizedThrowReplacements = EconomicMap.create();
        for (ForeignCallNode node : graph.getNodes().filter(ForeignCallNode.class).snapshot()) {
            if (optimizedCreateDescriptors.containsKey(node.getDescriptor())) {
                ReduceImplicitExceptionStackTraceInformationPhase.clearFrameStateForOptimizedCreate(node);
                continue;
            }
            if (!optimizedThrowDescriptors.containsKey(node.getDescriptor())) continue;
            ReduceImplicitExceptionStackTraceInformationPhase.combineForeignCallForOptimizedThrow(node, (EconomicMap<ForeignCallDescriptor, FixedNode>)optimizedThrowReplacements);
        }
    }

    private static void clearFrameStateForOptimizedCreate(ForeignCallNode originalForeignCall) {
        StructuredGraph graph = originalForeignCall.graph();
        ForeignCallDescriptor newDescriptor = optimizedCreateDescriptors.get(originalForeignCall.getDescriptor());
        FrameState originalState = originalForeignCall.stateDuring();
        FrameState newState = (FrameState)graph.add((Node)new FrameState(originalState.outerFrameState(), originalState.getCode(), 0, originalState.values().subList(0, originalState.locksSize()), originalState.localsSize(), 0, originalState.locksSize(), FrameState.StackState.AfterPop, false, (List)originalState.monitorIds(), (List)originalState.virtualObjectMappings(), null));
        ForeignCallNode newForeignCall = (ForeignCallNode)graph.add((Node)new ForeignCallNode(newDescriptor, originalForeignCall.stamp(NodeView.DEFAULT), List.of()));
        newForeignCall.setStateDuring(newState);
        graph.replaceFixedWithFixed((FixedWithNextNode)originalForeignCall, (FixedWithNextNode)newForeignCall);
    }

    private static void combineForeignCallForOptimizedThrow(ForeignCallNode originalForeignCall, EconomicMap<ForeignCallDescriptor, FixedNode> replacements) {
        EndNode newSuccessor;
        ForeignCallNode newForeignCall;
        StructuredGraph graph = originalForeignCall.graph();
        ForeignCallDescriptor newDescriptor = optimizedThrowDescriptors.get(originalForeignCall.getDescriptor());
        FixedNode existingReplacement = (FixedNode)replacements.get((Object)newDescriptor);
        if (existingReplacement == null) {
            FrameState outermostState = originalForeignCall.stateDuring();
            while (outermostState.outerFrameState() != null) {
                outermostState = outermostState.outerFrameState();
            }
            FrameState newStateDuring = (FrameState)graph.add((Node)new FrameState(null, outermostState.getCode(), 0, List.of(), outermostState.localsSize(), 0, 0, FrameState.StackState.AfterPop, false, null, null, null));
            newForeignCall = (ForeignCallNode)graph.add((Node)new ForeignCallNode(newDescriptor, originalForeignCall.stamp(NodeView.DEFAULT), List.of()));
            newForeignCall.setStateDuring(newStateDuring);
            newForeignCall.setNext((FixedNode)graph.add((Node)new LoweredDeadEndNode()));
            replacements.put((Object)newDescriptor, (Object)newForeignCall);
            newSuccessor = newForeignCall;
        } else {
            MergeNode replacementMerge;
            if (existingReplacement instanceof ForeignCallNode) {
                newForeignCall = (ForeignCallNode)existingReplacement;
                replacementMerge = (MergeNode)graph.add((Node)new MergeNode());
                replacements.put((Object)newDescriptor, (Object)replacementMerge);
                EndNode firstEnd = (EndNode)graph.add((Node)new EndNode());
                newForeignCall.replaceAtPredecessor((Node)firstEnd);
                replacementMerge.addForwardEnd(firstEnd);
                replacementMerge.setNext((FixedNode)newForeignCall);
            } else {
                replacementMerge = (MergeNode)existingReplacement;
                newForeignCall = (ForeignCallNode)replacementMerge.next();
            }
            EndNode newEnd = (EndNode)graph.add((Node)new EndNode());
            replacementMerge.addForwardEnd(newEnd);
            newSuccessor = newEnd;
        }
        originalForeignCall.replaceAtUsages((Node)newForeignCall);
        originalForeignCall.replaceAtPredecessor((Node)newSuccessor);
        GraphUtil.killCFG((FixedNode)originalForeignCall);
    }
}

