/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class AtomicFieldUpdaterFeature
implements InternalFeature {
    private boolean sealed = false;

    AtomicFieldUpdaterFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        config.registerObjectReachableCallback(AtomicReferenceFieldUpdater.class, this::processFieldUpdater);
        config.registerObjectReachableCallback(AtomicIntegerFieldUpdater.class, this::processFieldUpdater);
        config.registerObjectReachableCallback(AtomicLongFieldUpdater.class, this::processFieldUpdater);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    private void processFieldUpdater(Feature.DuringAnalysisAccess access, Object updater, ObjectScanner.ScanReason reason) {
        VMError.guarantee(!this.sealed, "New atomic field updater found after static analysis");
        Class<?> updaterClass = updater.getClass();
        Class tclass = (Class)ReflectionUtil.readField(updaterClass, (String)"tclass", (Object)updater);
        long searchOffset = (Long)ReflectionUtil.readField(updaterClass, (String)"offset", (Object)updater);
        for (Field f : tclass.getDeclaredFields()) {
            long fieldOffset;
            if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = Unsafe.getUnsafe().objectFieldOffset(f)) != searchOffset) continue;
            ((FeatureImpl.DuringAnalysisAccessImpl)access).registerAsUnsafeAccessed(f, (Object)reason);
            return;
        }
        throw VMError.shouldNotReachHere("unknown field offset class: " + String.valueOf(tclass) + ", offset = " + searchOffset);
    }
}

