/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.heap.SVMImageLayerWriter;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.VTableBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class LayeredDispatchTableSupport
implements LayeredImageSingleton {
    final Set<String> priorUnresolvedSymbols;
    final Map<Integer, PriorDispatchTable> priorDispatchTables;
    final Map<Integer, Set<String>> priorVirtualCallTargets;
    final Map<MethodPointer, HostedDispatchSlot> methodPointerToDispatchSlot = new IdentityHashMap<MethodPointer, HostedDispatchSlot>();
    final Map<HostedType, HostedDispatchTable> typeToDispatchTable = new HashMap<HostedType, HostedDispatchTable>();
    final Set<HostedMethod> virtualCallTargets = ImageLayerBuildingSupport.buildingSharedLayer() ? ConcurrentHashMap.newKeySet() : null;
    private final boolean generateUnresolvedSymbolNames = ImageLayerBuildingSupport.buildingSharedLayer();
    private Set<Module> builderModules;

    public LayeredDispatchTableSupport() {
        this(Map.of(), Set.of(), Map.of());
    }

    private LayeredDispatchTableSupport(Map<Integer, PriorDispatchTable> priorDispatchTables, Set<String> priorUnresolvedSymbols, Map<Integer, Set<String>> priorVirtualCallTargets) {
        this.priorDispatchTables = priorDispatchTables;
        this.priorUnresolvedSymbols = priorUnresolvedSymbols;
        this.priorVirtualCallTargets = priorVirtualCallTargets;
    }

    public static LayeredDispatchTableSupport singleton() {
        return (LayeredDispatchTableSupport)ImageSingletons.lookup(LayeredDispatchTableSupport.class);
    }

    void installBuilderModules(Set<Module> newCoreTypes) {
        assert (this.builderModules == null) : this.builderModules;
        this.builderModules = newCoreTypes;
    }

    public void recordVirtualCallTarget(HostedMethod caller, HostedMethod callee) {
        Module callerModule = caller.getDeclaringClass().getJavaClass().getModule();
        Module calleeModule = callee.getDeclaringClass().getJavaClass().getModule();
        if (!this.builderModules.contains(callerModule) && !this.builderModules.contains(calleeModule)) {
            this.virtualCallTargets.add(callee);
        }
    }

    static String generateFormattedMethodName(AnalysisMethod method) {
        return method.format("%n(%P)%R");
    }

    public void registerDeclaredDispatchInfo(HostedType type, List<HostedMethod> declaredMethods) {
        HostedDispatchTable dispatchTable = new HostedDispatchTable();
        dispatchTable.type = type;
        dispatchTable.locallyDeclaredSlots = (HostedMethod[])declaredMethods.toArray(HostedMethod[]::new);
        HostedDispatchTable prev = this.typeToDispatchTable.put(type, dispatchTable);
        assert (prev == null) : prev;
    }

    public void registerArrayDispatchTable(HostedType arrayType, HostedType objectType) {
        assert (!this.typeToDispatchTable.containsKey(arrayType));
        HostedDispatchTable objDispatchTable = this.typeToDispatchTable.get(objectType);
        HostedDispatchTable arrayDispatchTable = new HostedDispatchTable();
        arrayDispatchTable.type = arrayType;
        arrayDispatchTable.locallyDeclaredSlots = objDispatchTable.locallyDeclaredSlots;
        arrayDispatchTable.status = HubStatus.DISPATCH_INFO_CALCULATED;
        arrayDispatchTable.slots = (HostedDispatchSlot[])Arrays.stream(objDispatchTable.slots).map(objSlotInfo -> {
            HostedDispatchSlot arraySlotInfo = new HostedDispatchSlot();
            arraySlotInfo.dispatchTable = arrayDispatchTable;
            arraySlotInfo.declaredMethod = objSlotInfo.declaredMethod;
            arraySlotInfo.resolvedMethod = objSlotInfo.resolvedMethod;
            arraySlotInfo.slotNum = objSlotInfo.slotNum;
            arraySlotInfo.status = objSlotInfo.status;
            return arraySlotInfo;
        }).toArray(HostedDispatchSlot[]::new);
        this.injectPriorLayerInfo(arrayType, arrayDispatchTable);
        HostedDispatchTable prev = this.typeToDispatchTable.put(arrayType, arrayDispatchTable);
        assert (prev == null) : prev;
    }

    public void registerNonArrayDispatchTable(HostedType type, boolean[] validTarget) {
        HostedDispatchTable dispatchTable = this.typeToDispatchTable.get(type);
        dispatchTable.status = HubStatus.DISPATCH_INFO_CALCULATED;
        assert (dispatchTable.slots == null);
        HostedMethod[] resolvedMethods = type.getOpenTypeWorldDispatchTables();
        HostedMethod[] targetMethods = type.getOpenTypeWorldDispatchTableSlotTargets();
        int length = validTarget.length;
        assert (resolvedMethods.length == length && targetMethods.length == length) : Assertions.errorMessage((Object[])new Object[]{resolvedMethods, targetMethods, validTarget});
        HostedDispatchSlot[] slotInfos = new HostedDispatchSlot[length];
        for (int i = 0; i < length; ++i) {
            HostedDispatchSlot slot = new HostedDispatchSlot();
            slot.dispatchTable = dispatchTable;
            slot.slotNum = i;
            slot.resolvedMethod = validTarget[i] ? resolvedMethods[i] : null;
            slot.declaredMethod = targetMethods[i];
            slot.status = validTarget[i] ? SlotResolutionStatus.COMPUTED : SlotResolutionStatus.UNRESOLVED;
            slotInfos[i] = slot;
        }
        dispatchTable.slots = slotInfos;
        this.injectPriorLayerInfo(type, dispatchTable);
    }

    private void injectPriorLayerInfo(HostedType type, HostedDispatchTable dispatchTable) {
        PriorDispatchTable priorInfo;
        if (type.getWrapped().isInBaseLayer() && (priorInfo = this.priorDispatchTables.get(type.getWrapped().getId())) != null) {
            LayeredDispatchTableSupport.compareTypeInfo(dispatchTable, priorInfo);
            dispatchTable.status = HubStatus.INSTALLED_PRIOR_LAYER;
            for (int i = 0; i < dispatchTable.slots.length; ++i) {
                HostedDispatchSlot slot = dispatchTable.slots[i];
                PriorDispatchSlot priorSlot = priorInfo.slots[i];
                if (!priorSlot.status.isCompiled()) continue;
                slot.status = SlotResolutionStatus.PRIOR_LAYER;
                slot.symbol = priorSlot.slotSymbolName;
            }
        }
    }

    private static String compareMethod(HostedMethod curMethod, PriorDispatchMethod priorMethod) {
        int curVTableIdx;
        String priorSymbol;
        String curSymbol;
        Object errorMessage = "";
        int priorId = priorMethod.methodId();
        int curId = curMethod.getWrapped().getId();
        if (priorId != -1 && curId != priorId) {
            errorMessage = (String)errorMessage + String.format("mismatch in id %s %s%n", curId, priorId);
        }
        if (!(curSymbol = NativeImage.localSymbolNameForMethod(curMethod)).equals(priorSymbol = priorMethod.symbolName)) {
            errorMessage = (String)errorMessage + String.format("mismatch in symbol name %s %s%n", curSymbol, priorSymbol);
        }
        int priorVTableIdx = priorMethod.vtableIndex;
        int n = curVTableIdx = curMethod.hasVTableIndex() ? curMethod.getVTableIndex() : -1;
        if (priorVTableIdx != -1 && curVTableIdx != -1 && priorVTableIdx != curVTableIdx) {
            errorMessage = (String)errorMessage + String.format("mismatch in vtable index %s %s%n", curVTableIdx, priorVTableIdx);
        }
        if (!((String)errorMessage).isEmpty()) {
            errorMessage = String.format("Issue while comparing method %s %s%n", curMethod.getQualifiedName(), priorMethod) + (String)errorMessage;
        }
        return errorMessage;
    }

    private static void compareTypeInfo(HostedDispatchTable curInfo, PriorDispatchTable priorInfo) {
        int i;
        if (!Options.LogLayeredDispatchTableDiscrepancies.getValue().booleanValue() && !Options.ErrorOnLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
            return;
        }
        Object errorMessage = "";
        if (curInfo.locallyDeclaredSlots.length == priorInfo.locallyDeclaredSlots.length) {
            for (i = 0; i < curInfo.locallyDeclaredSlots.length; ++i) {
                errorMessage = (String)errorMessage + LayeredDispatchTableSupport.compareMethod(curInfo.locallyDeclaredSlots[i], priorInfo.locallyDeclaredSlots[i]);
            }
        } else {
            errorMessage = (String)errorMessage + String.format("Mismatch in locally declared slot length %s %s%n", curInfo.locallyDeclaredSlots.length, priorInfo.locallyDeclaredSlots.length);
        }
        if (curInfo.slots.length == priorInfo.slots.length) {
            for (i = 0; i < curInfo.slots.length; ++i) {
                HostedDispatchSlot curSlotInfo = curInfo.slots[i];
                PriorDispatchSlot priorSlotInfo = priorInfo.slots[i];
                LayeredDispatchTableSupport.compareMethod(curSlotInfo.declaredMethod, priorSlotInfo.declaredMethod);
                if (curSlotInfo.resolvedMethod == null || !priorSlotInfo.status.isResolved()) continue;
                LayeredDispatchTableSupport.compareMethod(curSlotInfo.resolvedMethod, priorSlotInfo.resolvedMethod);
            }
        } else {
            errorMessage = (String)errorMessage + String.format("Mismatch in dispatch table slot length %s %s%n", curInfo.slots.length, priorInfo.slots.length);
        }
        if (!((String)errorMessage).isEmpty()) {
            String message = String.format("Issue while comparing dispatch table info: %s and %s%n%s", curInfo, priorInfo, errorMessage);
            if (Options.ErrorOnLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
                throw VMError.shouldNotReachHere(message);
            }
            if (Options.LogLayeredDispatchTableDiscrepancies.getValue().booleanValue()) {
                System.out.println(message);
            }
        }
    }

    public void registerWrittenDynamicHub(DynamicHub hub, AnalysisUniverse aUniverse, HostedUniverse hUniverse, Object vTable) {
        AnalysisType aType = ((SVMHost)aUniverse.hostVM()).lookupType(hub);
        HostedType hType = hUniverse.lookup((JavaType)aType);
        assert (hType.getWrapped().isReachable()) : "All installed hubs should be reachable " + String.valueOf(hType);
        int vtableLength = Array.getLength(vTable);
        if (VTableBuilder.hasEmptyDispatchTable(hType)) {
            assert (vtableLength == 0) : hType;
            return;
        }
        HostedDispatchTable dispatchTable = this.typeToDispatchTable.get(hType);
        assert (dispatchTable.status == HubStatus.DISPATCH_INFO_CALCULATED) : dispatchTable;
        dispatchTable.status = HubStatus.INSTALLED_CURRENT_LAYER;
        assert (dispatchTable.slots.length == vtableLength) : Assertions.errorMessage((Object[])new Object[]{vTable, dispatchTable.slots});
        for (int i = 0; i < vtableLength; ++i) {
            MethodPointer methodPointer = (MethodPointer)Array.get(vTable, i);
            HostedDispatchSlot slot = dispatchTable.slots[i];
            HostedDispatchSlot prev = this.methodPointerToDispatchSlot.put(methodPointer, slot);
            assert (prev == null) : prev;
        }
    }

    private static String computeUnresolvedMethodSymbol(HostedDispatchSlot slotInfo, Map<ResolvedJavaMethod, String> methodToSymbolMap) {
        ResolvedJavaMethod resolvedMethod = null;
        if (slotInfo.status == SlotResolutionStatus.NOT_COMPILED) {
            resolvedMethod = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)slotInfo.resolvedMethod);
        } else {
            assert (slotInfo.status == SlotResolutionStatus.UNRESOLVED) : slotInfo;
            ResolvedJavaType originalType = OriginalClassProvider.getOriginalType((JavaType)slotInfo.dispatchTable.type);
            ResolvedJavaMethod originalMethod = OriginalMethodProvider.getOriginalMethod((ResolvedJavaMethod)slotInfo.declaredMethod);
            if (originalMethod != null) {
                resolvedMethod = originalType.resolveMethod(originalMethod, originalMethod.getDeclaringClass());
            }
        }
        Object unresolvedTableSymbol = resolvedMethod != null ? methodToSymbolMap.computeIfAbsent(resolvedMethod, k -> String.format("%s_unresolvedVTableSym", NativeImage.localSymbolNameForMethod(k))) : SubstrateOptions.ImageSymbolsPrefix.getValue() + String.format("unresolvedVTableSym_typeid%s_slot%s", slotInfo.dispatchTable.type.getWrapped().getId(), slotInfo.slotNum);
        return unresolvedTableSymbol;
    }

    /*
     * WARNING - void declaration
     */
    public void defineDispatchTableSlotSymbols(ObjectFile objectFile, ObjectFile.Section textSection, NativeImageCodeCache codeCache, HostedMetaAccess metaAccess) {
        HostedMethod invalidMethod = metaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        HashMap<String, HostedMethod> resolvedPriorVTableMap = new HashMap<String, HostedMethod>();
        HashSet<String> unresolvedVTableSymbolNames = this.generateUnresolvedSymbolNames ? new HashSet<String>() : null;
        HashMap<ResolvedJavaMethod, String> deduplicatedMethodMap = new HashMap<ResolvedJavaMethod, String>();
        for (HostedDispatchSlot hostedDispatchSlot : this.methodPointerToDispatchSlot.values()) {
            void var11_15;
            assert (hostedDispatchSlot.dispatchTable.status == HubStatus.INSTALLED_CURRENT_LAYER);
            if (hostedDispatchSlot.status == SlotResolutionStatus.COMPUTED) {
                hostedDispatchSlot.status = hostedDispatchSlot.resolvedMethod.isCompiled() ? SlotResolutionStatus.CURRENT_LAYER : SlotResolutionStatus.NOT_COMPILED;
            }
            Object var11_16 = null;
            if (!hostedDispatchSlot.status.isCompiled()) {
                String string;
                assert (hostedDispatchSlot.status == SlotResolutionStatus.UNRESOLVED || hostedDispatchSlot.status == SlotResolutionStatus.NOT_COMPILED) : hostedDispatchSlot;
                if (this.generateUnresolvedSymbolNames && unresolvedVTableSymbolNames.add(string = LayeredDispatchTableSupport.computeUnresolvedMethodSymbol(hostedDispatchSlot, deduplicatedMethodMap))) {
                    objectFile.createUndefinedSymbol(string, 0, true);
                }
            } else {
                String string = NativeImage.localSymbolNameForMethod(hostedDispatchSlot.resolvedMethod);
            }
            hostedDispatchSlot.symbol = var11_15;
        }
        for (HostedDispatchTable hostedDispatchTable : this.typeToDispatchTable.values()) {
            if (hostedDispatchTable.status != HubStatus.INSTALLED_PRIOR_LAYER) continue;
            for (HostedDispatchSlot slotInfo : hostedDispatchTable.slots) {
                if (slotInfo.status != SlotResolutionStatus.COMPUTED || !slotInfo.resolvedMethod.isCompiled()) continue;
                PriorDispatchTable priorInfo = this.priorDispatchTables.get(slotInfo.dispatchTable.type.getWrapped().getId());
                String symName = priorInfo.slots[slotInfo.slotNum].slotSymbolName;
                HostedMethod prev = resolvedPriorVTableMap.put(symName, slotInfo.resolvedMethod);
                assert (prev == null || prev.equals(slotInfo.resolvedMethod));
            }
        }
        for (Map.Entry entry : resolvedPriorVTableMap.entrySet()) {
            String string = (String)entry.getKey();
            HostedMethod method = (HostedMethod)entry.getValue();
            CompilationResult result = codeCache.compilationResultFor(method);
            int size = result == null ? 0 : result.getTargetCodeSize();
            objectFile.createDefinedSymbol(string, (ObjectFile.Element)textSection, (long)method.getCodeAddressOffset(), size, true, true);
        }
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            this.priorUnresolvedSymbols.forEach(symbol -> {
                if (!resolvedPriorVTableMap.containsKey(symbol)) {
                    CompilationResult result = codeCache.compilationResultFor(invalidMethod);
                    int size = result == null ? 0 : result.getTargetCodeSize();
                    objectFile.createDefinedSymbol(symbol, (ObjectFile.Element)textSection, (long)invalidMethod.getCodeAddressOffset(), size, true, true);
                }
            });
        }
    }

    public String getSymbolName(MethodPointer methodPointer, HostedMethod target, boolean injectedNotCompiled) {
        HostedDispatchSlot slotInfo = this.methodPointerToDispatchSlot.get(methodPointer);
        String symbol = NativeImage.localSymbolNameForMethod(target);
        if (slotInfo != null) {
            if (!slotInfo.status.isCompiled()) {
                assert (slotInfo.status == SlotResolutionStatus.UNRESOLVED || slotInfo.status == SlotResolutionStatus.NOT_COMPILED) : slotInfo;
                if (this.generateUnresolvedSymbolNames) {
                    assert (slotInfo.symbol != null) : slotInfo;
                    symbol = slotInfo.symbol;
                }
            } else assert (slotInfo.symbol.equals(symbol));
        }
        return symbol;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        SVMImageLayerWriter layerWriter = HostedImageLayerBuildingSupport.singleton().getWriter();
        HashMap methodToOffsetMap = new HashMap();
        ArrayList<Boolean> methodBooleans = new ArrayList<Boolean>();
        ArrayList<Integer> methodInts = new ArrayList<Integer>();
        ArrayList<String> methodStrings = new ArrayList<String>();
        Function<HostedMethod, Integer> methodToOffsetMapper = hMethod -> {
            int offset;
            if (methodToOffsetMap.containsKey(hMethod)) {
                offset = (Integer)methodToOffsetMap.get(hMethod);
            } else {
                offset = methodToOffsetMap.size();
                methodToOffsetMap.put(hMethod, offset);
                methodInts.add(layerWriter.isMethodPersisted(hMethod.getWrapped()) ? hMethod.wrapped.getId() : -1);
                methodInts.add(hMethod.hasVTableIndex() ? hMethod.getVTableIndex() : -1);
                methodBooleans.add(this.virtualCallTargets.contains(hMethod));
                methodStrings.add(NativeImage.localSymbolNameForMethod(hMethod));
                methodStrings.add(LayeredDispatchTableSupport.generateFormattedMethodName(hMethod.getWrapped()));
            }
            return offset;
        };
        ArrayList<Integer> dispatchTableInts = new ArrayList<Integer>();
        ArrayList<Integer> dispatchSlotInts = new ArrayList<Integer>();
        ArrayList<String> dispatchSlotStrings = new ArrayList<String>();
        int nextSlotIdx = 0;
        for (HostedDispatchTable info : this.typeToDispatchTable.values()) {
            if (!layerWriter.isTypePersisted(info.type.getWrapped())) {
                if ($assertionsDisabled) continue;
                if (!Arrays.stream(info.locallyDeclaredSlots).noneMatch(this.virtualCallTargets::contains)) {
                    throw new AssertionError((Object)("Type should be persisted: " + String.valueOf(info.type)));
                }
                continue;
            }
            ArrayList<Integer> localTargets = new ArrayList<Integer>();
            ArrayList<Integer> slotOffsets = new ArrayList<Integer>();
            for (HostedMethod hMethod2 : info.locallyDeclaredSlots) {
                localTargets.add(methodToOffsetMapper.apply(hMethod2));
            }
            if (info.slots != null) {
                for (HostedDispatchSlot slotInfo : info.slots) {
                    dispatchSlotStrings.add(slotInfo.symbol);
                    dispatchSlotInts.add(slotInfo.slotNum);
                    dispatchSlotInts.add(slotInfo.status.ordinal());
                    dispatchSlotInts.add(methodToOffsetMapper.apply(slotInfo.declaredMethod));
                    if (slotInfo.status.isResolved()) {
                        assert (slotInfo.resolvedMethod != null);
                        dispatchSlotInts.add(methodToOffsetMapper.apply(slotInfo.resolvedMethod));
                    } else {
                        dispatchSlotInts.add(-1);
                    }
                    slotOffsets.add(nextSlotIdx++);
                }
            }
            dispatchTableInts.add(info.type.getWrapped().getId());
            dispatchTableInts.add(localTargets.size());
            dispatchTableInts.add(slotOffsets.size());
            dispatchTableInts.addAll(localTargets);
            dispatchTableInts.addAll(slotOffsets);
        }
        writer.writeIntList("dispatchTableInts", dispatchTableInts);
        writer.writeIntList("dispatchSlotInts", dispatchSlotInts);
        writer.writeStringList("dispatchSlotStrings", dispatchSlotStrings);
        writer.writeBoolList("methodBooleans", methodBooleans);
        writer.writeIntList("methodInts", methodInts);
        writer.writeStringList("methodStrings", methodStrings);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        List<Integer> dispatchTableInts = loader.readIntList("dispatchTableInts");
        List<Integer> dispatchSlotInts = loader.readIntList("dispatchSlotInts");
        List<String> dispatchSlotStrings = loader.readStringList("dispatchSlotStrings");
        List<Boolean> methodBooleans = loader.readBoolList("methodBooleans");
        List<Integer> methodInts = loader.readIntList("methodInts");
        List<String> methodStrings = loader.readStringList("methodStrings");
        HashSet<String> unresolvedSymbols = new HashSet<String>();
        HashMap<Integer, PriorDispatchTable> priorTypes = new HashMap<Integer, PriorDispatchTable>();
        HashMap<Integer, Set<String>> priorVirtualCallTargets = new HashMap<Integer, Set<String>>();
        ArrayList<PriorDispatchMethod> priorMethods = new ArrayList<PriorDispatchMethod>();
        Iterator<Integer> intIterator = methodInts.iterator();
        Iterator<String> stringIterator = methodStrings.iterator();
        Iterator<Boolean> boolIterator = methodBooleans.iterator();
        while (stringIterator.hasNext()) {
            String symbol = stringIterator.next();
            String formattedName = stringIterator.next();
            int methodId = intIterator.next();
            int vtableIndex = intIterator.next();
            boolean isVirtualCallTarget = boolIterator.next();
            PriorDispatchMethod target = new PriorDispatchMethod(methodId, symbol, vtableIndex, formattedName, isVirtualCallTarget);
            priorMethods.add(target);
        }
        ArrayList<PriorDispatchSlot> priorDispatchSlots = new ArrayList<PriorDispatchSlot>();
        intIterator = dispatchSlotInts.iterator();
        for (String slotSymbolName : dispatchSlotStrings) {
            int slotNum = intIterator.next();
            SlotResolutionStatus status = SlotResolutionStatus.values()[intIterator.next()];
            PriorDispatchMethod declaredMethod = (PriorDispatchMethod)priorMethods.get(intIterator.next());
            PriorDispatchMethod resolvedMethod = null;
            int index = intIterator.next();
            if (index != -1) {
                resolvedMethod = (PriorDispatchMethod)priorMethods.get(index);
            }
            if (status == SlotResolutionStatus.UNRESOLVED || status == SlotResolutionStatus.NOT_COMPILED) {
                unresolvedSymbols.add(slotSymbolName);
            }
            PriorDispatchSlot slotInfo = new PriorDispatchSlot(declaredMethod, resolvedMethod, slotNum, status, slotSymbolName);
            priorDispatchSlots.add(slotInfo);
        }
        intIterator = dispatchTableInts.iterator();
        while (intIterator.hasNext()) {
            int i;
            int typeId = intIterator.next();
            int locallyDeclaredMethodsSize = intIterator.next();
            int allSlotsSize = intIterator.next();
            PriorDispatchMethod[] locallyDeclaredSlots = new PriorDispatchMethod[locallyDeclaredMethodsSize];
            PriorDispatchSlot[] dispatchTableSlots = new PriorDispatchSlot[allSlotsSize];
            for (i = 0; i < locallyDeclaredMethodsSize; ++i) {
                locallyDeclaredSlots[i] = (PriorDispatchMethod)priorMethods.get(intIterator.next());
            }
            for (i = 0; i < allSlotsSize; ++i) {
                dispatchTableSlots[i] = (PriorDispatchSlot)priorDispatchSlots.get(intIterator.next());
            }
            PriorDispatchTable priorDispatchTable = new PriorDispatchTable(typeId, locallyDeclaredSlots, dispatchTableSlots);
            Object prev = priorTypes.put(typeId, priorDispatchTable);
            assert (prev == null) : prev;
            Set priorVirtualCallNames = Arrays.stream(locallyDeclaredSlots).filter(PriorDispatchMethod::isVirtualCallTarget).map(PriorDispatchMethod::formattedName).collect(Collectors.toSet());
            if (priorVirtualCallNames.isEmpty()) continue;
            prev = priorVirtualCallTargets.put(typeId, priorVirtualCallNames);
            assert (prev == null) : prev;
        }
        return new LayeredDispatchTableSupport(priorTypes, unresolvedSymbols, priorVirtualCallTargets);
    }

    static class HostedDispatchTable {
        HostedType type;
        HostedMethod[] locallyDeclaredSlots;
        HostedDispatchSlot[] slots;
        HubStatus status = HubStatus.UNINITIALIZED;

        HostedDispatchTable() {
        }
    }

    static enum HubStatus {
        UNINITIALIZED,
        DISPATCH_INFO_CALCULATED,
        INSTALLED_PRIOR_LAYER,
        INSTALLED_CURRENT_LAYER;

    }

    static class HostedDispatchSlot {
        HostedDispatchTable dispatchTable;
        HostedMethod declaredMethod;
        HostedMethod resolvedMethod;
        int slotNum;
        SlotResolutionStatus status;
        String symbol;

        HostedDispatchSlot() {
        }
    }

    static enum SlotResolutionStatus {
        UNRESOLVED,
        COMPUTED,
        NOT_COMPILED,
        PRIOR_LAYER,
        CURRENT_LAYER;


        public boolean isResolved() {
            return this != UNRESOLVED;
        }

        public boolean isCompiled() {
            return this == PRIOR_LAYER || this == CURRENT_LAYER;
        }
    }

    record PriorDispatchTable(int typeID, PriorDispatchMethod[] locallyDeclaredSlots, PriorDispatchSlot[] slots) {
    }

    record PriorDispatchSlot(PriorDispatchMethod declaredMethod, PriorDispatchMethod resolvedMethod, int slotNum, SlotResolutionStatus status, String slotSymbolName) {
        static final int UNKNOWN_METHOD = -1;
    }

    record PriorDispatchMethod(int methodId, String symbolName, int vtableIndex, String formattedName, boolean isVirtualCallTarget) {
        static final int UNKNOWN_ID = -1;
        static final int UNKNOWN_VTABLE_IDX = -1;
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> LogLayeredDispatchTableDiscrepancies = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> ErrorOnLayeredDispatchTableDiscrepancies = new HostedOptionKey<Boolean>(false);
    }
}

