/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.LoadImageSingletonFactory;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.heap.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SlotInfo;
import com.oracle.svm.hosted.imagelayer.SlotRecordKind;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.Pointer;

class CrossLayerSingletonMappingInfo
extends LoadImageSingletonFactory
implements LayeredImageSingleton {
    private final Map<Class<?>, SlotInfo> priorKeyToSlotInfoMap;
    private final Map<Class<?>, List<Integer>> priorKeyToSingletonObjectIDsMap;
    private Map<Class<?>, SlotInfo> currentKeyToSlotInfoMap;
    private final Map<Class<?>, Integer> layerKeyToObjectIDMap = new HashMap();
    private final Map<Class<?>, LoadImageSingletonDataImpl> layerKeyToSingletonDataMap = new ConcurrentHashMap();
    boolean sealedSingletonLookup = false;
    private CGlobalData<Pointer> singletonTableStart;
    int referenceSize = 0;

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    CrossLayerSingletonMappingInfo() {
        this.priorKeyToSlotInfoMap = Map.of();
        this.priorKeyToSingletonObjectIDsMap = Map.of();
    }

    CrossLayerSingletonMappingInfo(Map<Class<?>, SlotInfo> priorKeyToSlotInfoMap, Map<Class<?>, List<Integer>> priorKeyToSingletonObjectIDsMap) {
        this.priorKeyToSlotInfoMap = priorKeyToSlotInfoMap;
        this.priorKeyToSingletonObjectIDsMap = priorKeyToSingletonObjectIDsMap;
    }

    void recordConstantID(Class<?> keyClass, int objectID) {
        Integer previous = this.layerKeyToObjectIDMap.put(keyClass, objectID);
        assert (previous == null) : previous;
    }

    Map<Class<?>, SlotInfo> getCurrentKeyToSlotInfoMap() {
        assert (this.currentKeyToSlotInfoMap != null);
        return this.currentKeyToSlotInfoMap;
    }

    Map<Class<?>, SlotInfo> getPriorKeyToSlotInfoMap() {
        return this.priorKeyToSlotInfoMap;
    }

    List<Integer> getPriorLayerObjectIDs(Class<?> keyClass) {
        return this.priorKeyToSingletonObjectIDsMap.getOrDefault(keyClass, List.of());
    }

    private LoadImageSingletonFactory.LoadImageSingletonData getImageSingletonInfo(Class<?> keyClass, SlotRecordKind kind) {
        assert (!this.sealedSingletonLookup);
        assert (!ImageLayerBuildingSupport.buildingApplicationLayer()) : "Singletons can always be directly folded in the application layer";
        LoadImageSingletonDataImpl result = this.layerKeyToSingletonDataMap.get(keyClass);
        if (result != null) {
            return result;
        }
        LoadImageSingletonDataImpl newInfo = new LoadImageSingletonDataImpl(keyClass, kind);
        result = this.layerKeyToSingletonDataMap.computeIfAbsent(keyClass, k -> newInfo);
        if (result != newInfo) {
            return result;
        }
        SlotInfo priorSlotInfo = this.priorKeyToSlotInfoMap.get(keyClass);
        if (priorSlotInfo != null && priorSlotInfo.recordKind() != kind) {
            VMError.shouldNotReachHere("A singleton cannot implement both %s and %s", new Object[]{priorSlotInfo.recordKind(), kind});
        }
        return newInfo;
    }

    @Override
    protected LoadImageSingletonFactory.LoadImageSingletonData getApplicationLayerOnlyImageSingletonInfo(Class<?> keyClass) {
        assert (!ImageLayerBuildingSupport.buildingApplicationLayer()) : "In the application layer one can directly load the constant";
        return this.getImageSingletonInfo(keyClass, SlotRecordKind.APPLICATION_LAYER_SINGLETON);
    }

    @Override
    protected LoadImageSingletonFactory.LoadImageSingletonData getLayeredImageSingletonInfo(Class<?> keyClass) {
        return this.getImageSingletonInfo(keyClass, SlotRecordKind.MULTI_LAYERED_SINGLETON);
    }

    void assignSlots(HostedMetaAccess metaAccess) {
        OptionalInt priorMax;
        this.sealedSingletonLookup = true;
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            this.referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            this.singletonTableStart = CGlobalDataFactory.forSymbol("__layered_singleton_table_start");
        }
        int nextFreeSlot = (priorMax = this.priorKeyToSlotInfoMap.values().stream().mapToInt(SlotInfo::slotNum).max()).isPresent() ? priorMax.getAsInt() + 1 : 0;
        this.currentKeyToSlotInfoMap = new HashMap(this.priorKeyToSlotInfoMap);
        List<Map.Entry> sortedEntries = this.layerKeyToSingletonDataMap.entrySet().stream().sorted(Comparator.comparing(e -> ((Class)e.getKey()).getName())).toList();
        for (Map.Entry entry : sortedEntries) {
            LoadImageSingletonDataImpl info = (LoadImageSingletonDataImpl)entry.getValue();
            ResolvedJavaType hType = metaAccess.lookupJavaType((Class)info.getLoadType());
            if (!hType.isInstantiated()) continue;
            Class keyClass = (Class)entry.getKey();
            SlotInfo slotInfo = this.priorKeyToSlotInfoMap.get(entry.getKey());
            if (slotInfo == null) {
                int slotAssignment = nextFreeSlot++;
                slotInfo = new SlotInfo(keyClass, slotAssignment, info.kind);
            }
            SlotInfo prior = this.currentKeyToSlotInfoMap.put(keyClass, slotInfo);
            assert (prior == null) : prior;
        }
    }

    private static String getKeyClassName(Class<?> clazz) {
        return clazz.getName();
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        ArrayList<String> keyClasses = new ArrayList<String>();
        ArrayList<Integer> slotAssignments = new ArrayList<Integer>();
        ArrayList<String> slotKinds = new ArrayList<String>();
        for (SlotInfo slotInfo : this.currentKeyToSlotInfoMap.values()) {
            String string = CrossLayerSingletonMappingInfo.getKeyClassName(slotInfo.keyClass());
            keyClasses.add(string);
            slotAssignments.add(slotInfo.slotNum());
            slotKinds.add(slotInfo.recordKind().name());
        }
        writer.writeStringList("keyClasses", keyClasses);
        writer.writeIntList("slotAssignments", slotAssignments);
        writer.writeStringList("slotKinds", slotKinds);
        HashMap currentKeyToSingletonObjectIDsMap = new HashMap(this.priorKeyToSingletonObjectIDsMap);
        for (Class<?> clazz : LayeredImageSingletonSupport.singleton().getMultiLayeredImageSingletonKeys()) {
            Integer id = this.layerKeyToObjectIDMap.get(clazz);
            assert (id != null) : "Missing multiLayerKey " + String.valueOf(clazz);
            currentKeyToSingletonObjectIDsMap.compute(clazz, (k, v) -> {
                if (v == null) {
                    return List.of(id);
                }
                ArrayList<Integer> newList = new ArrayList<Integer>((Collection<Integer>)v);
                newList.add(id);
                return newList;
            });
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int count = 0;
        for (Map.Entry entry : currentKeyToSingletonObjectIDsMap.entrySet()) {
            String keyClassName = CrossLayerSingletonMappingInfo.getKeyClassName((Class)entry.getKey());
            String idListKey = String.format("priorObjectIds-%s", count++);
            writer.writeIntList(idListKey, (List)entry.getValue());
            arrayList.add(idListKey);
            arrayList2.add(keyClassName);
        }
        writer.writeStringList("multiLayerClassNames", arrayList2);
        writer.writeStringList("multiLayerKeyNames", arrayList);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SVMImageLayerLoader imageLayerLoader = HostedImageLayerBuildingSupport.singleton().getLoader();
        Iterator<String> keyClasses = loader.readStringList("keyClasses").iterator();
        Iterator<Integer> slotAssignments = loader.readIntList("slotAssignments").iterator();
        Iterator<String> slotKinds = loader.readStringList("slotKinds").iterator();
        HashMap keyClassToSlotInfoMap = new HashMap();
        while (keyClasses.hasNext()) {
            String keyName = keyClasses.next();
            Class<?> keyClass = imageLayerLoader.lookupClass(false, keyName);
            int slotAssignment = slotAssignments.next();
            SlotRecordKind slotKind = SlotRecordKind.valueOf(slotKinds.next());
            SlotInfo previous = keyClassToSlotInfoMap.put(keyClass, new SlotInfo(keyClass, slotAssignment, slotKind));
            assert (previous == null) : previous;
        }
        HashMap keyClassToObjectIDListMap = new HashMap();
        keyClasses = loader.readStringList("multiLayerClassNames").iterator();
        Iterator<String> idKeyNames = loader.readStringList("multiLayerKeyNames").iterator();
        while (keyClasses.hasNext()) {
            String keyClassName = keyClasses.next();
            Class<?> keyClass = imageLayerLoader.lookupClass(false, keyClassName);
            String idKeyName = idKeyNames.next();
            List<Integer> list = loader.readIntList(idKeyName);
            assert (list != null);
            List<Integer> previous = keyClassToObjectIDListMap.put(keyClass, list);
            assert (previous == null);
        }
        return new CrossLayerSingletonMappingInfo(Map.copyOf(keyClassToSlotInfoMap), Map.copyOf(keyClassToObjectIDListMap));
    }

    class LoadImageSingletonDataImpl
    implements LoadImageSingletonFactory.LoadImageSingletonData {
        private final Class<?> key;
        private final SlotRecordKind kind;

        LoadImageSingletonDataImpl(Class<?> key, SlotRecordKind kind) {
            this.key = key;
            this.kind = kind;
        }

        @Override
        public Class<?> getLoadType() {
            return this.kind == SlotRecordKind.APPLICATION_LAYER_SINGLETON ? this.key : this.key.arrayType();
        }

        @Override
        public LoadImageSingletonFactory.SingletonAccessInfo getAccessInfo() {
            assert (CrossLayerSingletonMappingInfo.this.singletonTableStart != null);
            CGlobalDataInfo cglobal = CGlobalDataFeature.singleton().registerAsAccessedOrGet(CrossLayerSingletonMappingInfo.this.singletonTableStart);
            int slotNum = CrossLayerSingletonMappingInfo.this.currentKeyToSlotInfoMap.get(this.key).slotNum();
            return new LoadImageSingletonFactory.SingletonAccessInfo(cglobal, slotNum * CrossLayerSingletonMappingInfo.this.referenceSize);
        }
    }
}

