/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import java.nio.ByteBuffer;
import jdk.graal.compiler.core.common.NumUtil;

class UNWIND_INFO {
    private static final int SIZE = 4;
    static final byte VERSION = 1;
    static final byte UNW_FLAG_NHANDLER = 0;
    static final byte UNW_FLAG_CHAININFO = 4;
    static final byte RBP = 5;

    UNWIND_INFO() {
    }

    static int size(int countOfCodes, boolean chained) {
        int size = 4 + (countOfCodes + 1 & 0xFFFFFFFE) * 2;
        if (chained) {
            size += 12;
        }
        return size;
    }

    static void emit(ByteBuffer buffer, int sizeOfProlog, int countOfCodes, byte frameRegister, int frameOffset, UnwindCodeEmitter unwindCodes) {
        UNWIND_INFO.emit(buffer, (byte)1, (byte)0, sizeOfProlog, countOfCodes, frameRegister, frameOffset, unwindCodes);
    }

    static void emit(ByteBuffer buffer, int sizeOfProlog, int countOfCodes, byte frameRegister, int frameOffset, UnwindCodeEmitter unwindCodes, ChainedInfoEmitter chainedInfo) {
        UNWIND_INFO.emit(buffer, (byte)1, (byte)4, sizeOfProlog, countOfCodes, frameRegister, frameOffset, unwindCodes);
        int chainedInfoPosition = buffer.position();
        chainedInfo.emit();
        assert (buffer.position() == chainedInfoPosition + 12) : "wrong chained info emitted";
    }

    private static void emit(ByteBuffer buffer, byte version, byte flags, int sizeOfProlog, int countOfCodes, byte frameRegister, int frameOffset, UnwindCodeEmitter unwindCodes) {
        assert (buffer.position() % 4 == 0) : "wrong alignment";
        assert (version < 8) : version;
        assert (flags <= 4) : flags;
        assert (frameRegister < 16) : frameRegister;
        assert (frameOffset <= 240 && frameOffset % 16 == 0) : frameOffset;
        buffer.put(NumUtil.safeToUByte((int)(flags << 3 | version)));
        buffer.put(NumUtil.safeToUByte((int)sizeOfProlog));
        buffer.put(NumUtil.safeToUByte((int)countOfCodes));
        buffer.put(NumUtil.safeToUByte((int)(frameOffset | frameRegister)));
        int firstUnwindCode = buffer.position();
        unwindCodes.emit();
        assert (buffer.position() == firstUnwindCode + countOfCodes * 2) : "wrong number of unwind codes emitted";
        if ((countOfCodes & 1) != 0) {
            buffer.putShort((short)0);
        }
    }

    static interface UnwindCodeEmitter {
        public void emit();
    }

    static interface ChainedInfoEmitter {
        public void emit();
    }
}

