/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import java.nio.ByteBuffer;

class RUNTIME_FUNCTION {
    static final int SIZE = 12;
    static final int PRIMARY_RANGE = 0;

    RUNTIME_FUNCTION() {
    }

    static boolean isPrimary(int range) {
        return range == 0;
    }

    static boolean isChained(int range) {
        return !RUNTIME_FUNCTION.isPrimary(range);
    }

    static String unwindInfoSymbolPrefixFor(int range) {
        return RUNTIME_FUNCTION.isPrimary(range) ? "$unwind$" : "$chain$" + (range - 1) + "$";
    }

    static void emitCopyOf(BasicProgbitsSectionImpl section, ByteBuffer buffer, String symbolName, ByteBuffer runtimeFunction) {
        int range = runtimeFunction.position() / 12;
        int start = runtimeFunction.getInt();
        int end = runtimeFunction.getInt();
        RUNTIME_FUNCTION.emit(section, buffer, symbolName, range, start, end);
    }

    static void emit(BasicProgbitsSectionImpl section, ByteBuffer buffer, String symbolName, int range, int start, int end) {
        String unwindInfoSymbolName = RUNTIME_FUNCTION.unwindInfoSymbolPrefixFor(range) + symbolName;
        RUNTIME_FUNCTION.emit(section, buffer, symbolName, start, end, unwindInfoSymbolName);
    }

    private static void emit(BasicProgbitsSectionImpl section, ByteBuffer buffer, String symbolName, int start, int end, String unwindInfoSymbolName) {
        assert (buffer.position() % 4 == 0) : "wrong alignment";
        assert (start < end) : "invalid range";
        int offset = buffer.position();
        section.markRelocationSite(offset, ObjectFile.RelocationKind.ADDR32NB_4, symbolName, (long)start);
        section.markRelocationSite(offset + 4, ObjectFile.RelocationKind.ADDR32NB_4, symbolName, (long)end);
        section.markRelocationSite(offset + 8, ObjectFile.RelocationKind.ADDR32NB_4, unwindInfoSymbolName, 0L);
        buffer.position(offset + 12);
    }
}

