/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.heap.ImageLayerWriter;
import com.oracle.graal.pointsto.heap.ImageLayerWriterHelper;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.jni.JNIJavaCallVariantWrapperMethod;
import com.oracle.svm.hosted.reflect.ReflectionExpandSignatureMethod;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Arrays;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;

public class SVMImageLayerWriterHelper
extends ImageLayerWriterHelper {
    public SVMImageLayerWriterHelper(ImageLayerWriter imageLayerWriter) {
        super(imageLayerWriter);
    }

    protected void persistType(AnalysisType type, EconomicMap<String, Object> typeMap) {
        if (type.toJavaName(true).contains("jdk.internal.reflect.GeneratedSerializationConstructorAccessor")) {
            typeMap.put((Object)"wrapped type", (Object)"generated serialization");
            SerializationSupport.SerializationLookupKey key = SerializationSupport.singleton().getKeyFromConstructorAccessorClass(type.getJavaClass());
            typeMap.put((Object)"raw declaring class", (Object)key.getDeclaringClass().getName());
            typeMap.put((Object)"raw target constructor class", (Object)key.getTargetConstructorClass().getName());
        } else if (LambdaUtils.isLambdaType((ResolvedJavaType)type)) {
            typeMap.put((Object)"wrapped type", (Object)"lambda type");
            typeMap.put((Object)"capturing class", (Object)LambdaUtils.capturingClass((String)type.toJavaName()));
        } else if (ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type)) {
            typeMap.put((Object)"wrapped type", (Object)"proxy type");
        }
        super.persistType(type, typeMap);
    }

    protected void persistMethod(AnalysisMethod method, EconomicMap<String, Object> methodMap) {
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            methodMap.put((Object)"wrapped method", (Object)"factory");
            targetConstructor = method.getUniverse().lookup((JavaMethod)factoryMethod.getTargetConstructor());
            this.imageLayerWriter.persistAnalysisParsedGraph((AnalysisMethod)targetConstructor);
            this.imageLayerWriter.persistMethod((AnalysisMethod)targetConstructor);
            methodMap.put((Object)"target constructor", (Object)targetConstructor.getId());
            methodMap.put((Object)"throw allocated object", (Object)factoryMethod.throwAllocatedObject());
            AnalysisType instantiatedType = method.getUniverse().lookup((JavaType)factoryMethod.getInstantiatedType());
            methodMap.put((Object)"instantiated type", (Object)instantiatedType.getId());
        } else {
            targetConstructor = method.wrapped;
            if (targetConstructor instanceof CEntryPointCallStubMethod) {
                CEntryPointCallStubMethod cEntryPointCallStubMethod = (CEntryPointCallStubMethod)targetConstructor;
                methodMap.put((Object)"wrapped method", (Object)"CEntryPointCallStubMethod");
                originalMethod = CEntryPointCallStubSupport.singleton().getMethodForStub(cEntryPointCallStubMethod);
                methodMap.put((Object)"original method id", (Object)originalMethod.getId());
                methodMap.put((Object)"not as published", (Object)cEntryPointCallStubMethod.isNotPublished());
            } else {
                originalMethod = method.wrapped;
                if (originalMethod instanceof ReflectionExpandSignatureMethod) {
                    ReflectionExpandSignatureMethod reflectionExpandSignatureMethod = (ReflectionExpandSignatureMethod)originalMethod;
                    methodMap.put((Object)"wrapped method", (Object)"reflection expand signature method");
                    member = reflectionExpandSignatureMethod.getMember();
                    SVMImageLayerWriterHelper.persistWrappedMember(methodMap, (Executable)member);
                } else {
                    member = method.wrapped;
                    if (member instanceof JNIJavaCallVariantWrapperMethod) {
                        JNIJavaCallVariantWrapperMethod jniJavaCallVariantWrapperMethod = (JNIJavaCallVariantWrapperMethod)member;
                        Executable executable = jniJavaCallVariantWrapperMethod.getMember();
                        methodMap.put((Object)"wrapped method", (Object)"jni java call variant wrapper method");
                        SVMImageLayerWriterHelper.persistWrappedMember(methodMap, executable);
                    }
                }
            }
        }
        super.persistMethod(method, methodMap);
    }

    private static void persistWrappedMember(EconomicMap<String, Object> methodMap, Executable member) {
        methodMap.put((Object)"wrapped member class", (Object)member.getDeclaringClass().getName());
        methodMap.put((Object)"wrapped member name", (Object)(member instanceof Constructor ? "<init>" : member.getName()));
        methodMap.put((Object)"wrapped member arguments", Arrays.stream(member.getParameters()).map(p -> p.getType().getName()).toList());
    }
}

