/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.heap.ImageLayerWriter;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.VMFeature;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.code.IncompatibleClassChangeFallbackMethod;
import com.oracle.svm.hosted.heap.SVMImageLayerLoader;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.graal.compiler.util.ObjectCopierInputStream;
import jdk.graal.compiler.util.ObjectCopierOutputStream;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageLayerSnapshotUtil
extends ImageLayerSnapshotUtil {
    public static final String GENERATED_SERIALIZATION = "jdk.internal.reflect.GeneratedSerializationConstructorAccessor";
    public static final Field companion = ReflectionUtil.lookupField(DynamicHub.class, (String)"companion");
    public static final Field classInitializationInfo = ReflectionUtil.lookupField(DynamicHub.class, (String)"classInitializationInfo");
    private static final Field name = ReflectionUtil.lookupField(DynamicHub.class, (String)"name");
    private static final Field superHub = ReflectionUtil.lookupField(DynamicHub.class, (String)"superHub");
    private static final Field componentType = ReflectionUtil.lookupField(DynamicHub.class, (String)"componentType");
    public static final Field arrayHub = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");
    public static final Field interfacesEncoding = ReflectionUtil.lookupField(DynamicHub.class, (String)"interfacesEncoding");
    public static final Field enumConstantsReference = ReflectionUtil.lookupField(DynamicHub.class, (String)"enumConstantsReference");
    protected static final Set<Field> dynamicHubRelinkedFields = Set.of(companion, classInitializationInfo, name, superHub, componentType, arrayHub);
    protected final Map<AnalysisType, Set<Integer>> fieldsToRelink = new HashMap<AnalysisType, Set<Integer>>();
    private final ImageClassLoader imageClassLoader;

    public SVMImageLayerSnapshotUtil(ImageClassLoader imageClassLoader) {
        this.imageClassLoader = imageClassLoader;
        this.addSVMExternalValueFields();
    }

    private void addSVMExternalValueFields() {
        for (URI svmURI : this.getBuilderLocations()) {
            for (String className : this.imageClassLoader.classLoaderSupport.classes(svmURI)) {
                try {
                    Class<?> clazz = this.imageClassLoader.forName(className);
                    String packageName = clazz.getPackageName();
                    if (!this.shouldScanPackage(packageName)) continue;
                    Module module = clazz.getModule();
                    ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ObjectCopier.class, (boolean)false, (String)module.getName(), (String[])new String[]{packageName});
                    ObjectCopier.addStaticFinalObjectFields(clazz, (List)this.externalValueFields);
                }
                catch (ClassNotFoundException e) {
                    throw AnalysisError.shouldNotReachHere((String)"The class %s from the modulePath %s was not found".formatted(className, svmURI.getPath()), (Throwable)e);
                }
            }
        }
    }

    protected Set<URI> getBuilderLocations() {
        try {
            Class<?> vmFeatureClass = ((VMFeature)ImageSingletons.lookup(VMFeature.class)).getClass();
            URI svmURI = VMFeature.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (vmFeatureClass == VMFeature.class) {
                return Set.of(svmURI);
            }
            return Set.of(svmURI, vmFeatureClass.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere("Error when trying to get SVM URI", e);
        }
    }

    protected boolean shouldScanPackage(String packageName) {
        return true;
    }

    public String getTypeIdentifier(AnalysisType type) {
        if (type.toJavaName(true).contains(GENERATED_SERIALIZATION)) {
            return SVMImageLayerSnapshotUtil.getGeneratedSerializationName(type);
        }
        if (ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type)) {
            return type.toJavaName(true);
        }
        return super.getTypeIdentifier(type);
    }

    private static String generatedSerializationClassName(SerializationSupport.SerializationLookupKey serializationLookupKey) {
        return "jdk.internal.reflect.GeneratedSerializationConstructorAccessor:" + String.valueOf(serializationLookupKey.getDeclaringClass()) + "," + String.valueOf(serializationLookupKey.getTargetConstructorClass());
    }

    public String getMethodIdentifier(AnalysisMethod method) {
        Executable originalMethod;
        AnalysisType declaringClass = method.getDeclaringClass();
        String moduleName = declaringClass.getJavaClass().getModule().getName();
        if (declaringClass.toJavaName(true).contains(GENERATED_SERIALIZATION)) {
            return SVMImageLayerSnapshotUtil.getGeneratedSerializationName(declaringClass) + ":" + method.getName();
        }
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            AnalysisMethod targetConstructor = method.getUniverse().lookup((JavaMethod)factoryMethod.getTargetConstructor());
            return SVMImageLayerSnapshotUtil.addModuleName((String)(targetConstructor.getDeclaringClass().toJavaName(true) + SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method)), (String)moduleName);
        }
        if (method.wrapped instanceof IncompatibleClassChangeFallbackMethod && (originalMethod = method.getJavaMethod()) != null) {
            return SVMImageLayerSnapshotUtil.addModuleName((String)(method.getQualifiedName() + " " + method.getJavaMethod().toString()), (String)moduleName);
        }
        if (!(method.wrapped instanceof HotSpotResolvedJavaMethod)) {
            return SVMImageLayerSnapshotUtil.addModuleName((String)SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method), (String)moduleName);
        }
        if (LambdaUtils.isLambdaType((ResolvedJavaType)declaringClass) || InjectedInvokerRenamingSubstitutionProcessor.isInjectedInvokerType((ResolvedJavaType)declaringClass) || MethodHandleInvokerRenamingSubstitutionProcessor.isMethodHandleType((ResolvedJavaType)declaringClass) || ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)declaringClass)) {
            return SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method);
        }
        return super.getMethodIdentifier(method);
    }

    private static String getGeneratedSerializationName(AnalysisType type) {
        Class constructorAccessor = type.getJavaClass();
        SerializationSupport serializationRegistry = SerializationSupport.singleton();
        SerializationSupport.SerializationLookupKey serializationLookupKey = serializationRegistry.getKeyFromConstructorAccessorClass(constructorAccessor);
        return SVMImageLayerSnapshotUtil.generatedSerializationClassName(serializationLookupKey);
    }

    public Set<Integer> getRelinkedFields(AnalysisType type, AnalysisMetaAccess metaAccess) {
        Set result = this.fieldsToRelink.computeIfAbsent(type, key -> {
            Class clazz = type.getJavaClass();
            if (clazz == Class.class) {
                type.getInstanceFields(true);
                return dynamicHubRelinkedFields.stream().map(arg_0 -> ((AnalysisMetaAccess)metaAccess).lookupJavaField(arg_0)).map(AnalysisField::getPosition).collect(Collectors.toSet());
            }
            return null;
        });
        if (result == null) {
            return Set.of();
        }
        return result;
    }

    public ImageLayerSnapshotUtil.GraphEncoder getGraphEncoder(ImageLayerWriter imageLayerWriter) {
        return new SVMGraphEncoder(this.externalValues, imageLayerWriter);
    }

    public ImageLayerSnapshotUtil.GraphDecoder getGraphDecoder(ImageLayerLoader imageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider) {
        return new SVMGraphDecoder(EncodedGraph.class.getClassLoader(), (SVMImageLayerLoader)imageLayerLoader, analysisMethod, snippetReflectionProvider);
    }

    private static void makeStaticFieldIds(ObjectCopier.Encoder encoder, ObjectCopier.ObjectPath objectPath, Object object) {
        Field staticField = (Field)encoder.getExternalValues().get(object);
        encoder.makeStringId(staticField.getDeclaringClass().getName(), objectPath);
        encoder.makeStringId(staticField.getName(), objectPath);
    }

    private static void writeStaticField(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object object) throws IOException {
        Field staticField = (Field)encoder.getExternalValues().get(object);
        encoder.writeString(stream, staticField.getDeclaringClass().getName());
        encoder.writeString(stream, staticField.getName());
    }

    private static <T> T readStaticFieldAndGetObject(ObjectCopier.Decoder decoder, ObjectCopierInputStream stream) throws IOException {
        String className = decoder.readString(stream);
        String fieldName = decoder.readString(stream);
        Class declaringClass = ReflectionUtil.lookupClass((boolean)false, (String)className);
        return (T)ReflectionUtil.readStaticField((Class)declaringClass, (String)fieldName);
    }

    public static class SVMGraphEncoder
    extends ImageLayerSnapshotUtil.GraphEncoder {
        public SVMGraphEncoder(Map<Object, Field> externalValues, ImageLayerWriter imageLayerWriter) {
            super(externalValues, imageLayerWriter);
            this.addBuiltin(new HostedTypeBuiltIn(null));
            this.addBuiltin(new HostedMethodBuiltIn(null));
            this.addBuiltin(new HostedOptionValuesBuiltIn());
            this.addBuiltin(new HostedSnippetReflectionProviderBuiltIn(null));
            this.addBuiltin(new CInterfaceLocationIdentityBuiltIn());
            this.addBuiltin(new FastThreadLocalLocationIdentityBuiltIn());
            this.addBuiltin(new VMThreadLocalInfoBuiltIn());
        }
    }

    public static class SVMGraphDecoder
    extends ImageLayerSnapshotUtil.GraphDecoder {
        public SVMGraphDecoder(ClassLoader classLoader, SVMImageLayerLoader svmImageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider) {
            super(classLoader, (ImageLayerLoader)svmImageLayerLoader, analysisMethod);
            this.addBuiltin(new HostedTypeBuiltIn(svmImageLayerLoader));
            this.addBuiltin(new HostedMethodBuiltIn(svmImageLayerLoader));
            this.addBuiltin(new HostedOptionValuesBuiltIn());
            this.addBuiltin(new HostedSnippetReflectionProviderBuiltIn(snippetReflectionProvider));
            this.addBuiltin(new CInterfaceLocationIdentityBuiltIn());
            this.addBuiltin(new FastThreadLocalLocationIdentityBuiltIn());
            this.addBuiltin(new VMThreadLocalInfoBuiltIn());
        }
    }

    public static class VMThreadLocalInfoBuiltIn
    extends ObjectCopier.Builtin {
        protected VMThreadLocalInfoBuiltIn() {
            super(VMThreadLocalInfo.class, new Class[0]);
        }

        private static FastThreadLocal getThreadLocal(Object obj) {
            VMThreadLocalCollector vmThreadLocalCollector = (VMThreadLocalCollector)ImageSingletons.lookup(VMThreadLocalCollector.class);
            return vmThreadLocalCollector.getThreadLocal((VMThreadLocalInfo)obj);
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            SVMImageLayerSnapshotUtil.makeStaticFieldIds(encoder, objectPath, VMThreadLocalInfoBuiltIn.getThreadLocal(obj));
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            SVMImageLayerSnapshotUtil.writeStaticField(encoder, stream, VMThreadLocalInfoBuiltIn.getThreadLocal(obj));
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            FastThreadLocal fastThreadLocal = (FastThreadLocal)SVMImageLayerSnapshotUtil.readStaticFieldAndGetObject(decoder, stream);
            return ((VMThreadLocalCollector)ImageSingletons.lookup(VMThreadLocalCollector.class)).forFastThreadLocal(fastThreadLocal);
        }
    }

    public static class FastThreadLocalLocationIdentityBuiltIn
    extends ObjectCopier.Builtin {
        protected FastThreadLocalLocationIdentityBuiltIn() {
            super(FastThreadLocal.FastThreadLocalLocationIdentity.class, new Class[0]);
        }

        private static FastThreadLocal getFastThreadLocal(Object obj) {
            FastThreadLocal.FastThreadLocalLocationIdentity fastThreadLocalLocationIdentity = (FastThreadLocal.FastThreadLocalLocationIdentity)((Object)obj);
            return (FastThreadLocal)ReflectionUtil.readField(FastThreadLocal.FastThreadLocalLocationIdentity.class, (String)"this$0", (Object)((Object)fastThreadLocalLocationIdentity));
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            SVMImageLayerSnapshotUtil.makeStaticFieldIds(encoder, objectPath, FastThreadLocalLocationIdentityBuiltIn.getFastThreadLocal(obj));
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            SVMImageLayerSnapshotUtil.writeStaticField(encoder, stream, FastThreadLocalLocationIdentityBuiltIn.getFastThreadLocal(obj));
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            FastThreadLocal fastThreadLocal = (FastThreadLocal)SVMImageLayerSnapshotUtil.readStaticFieldAndGetObject(decoder, stream);
            return fastThreadLocal.getLocationIdentity();
        }
    }

    public static class CInterfaceLocationIdentityBuiltIn
    extends ObjectCopier.Builtin {
        protected CInterfaceLocationIdentityBuiltIn() {
            super(CInterfaceLocationIdentity.class, new Class[0]);
        }

        private static String asString(Object obj) {
            CInterfaceLocationIdentity cInterfaceLocationIdentity = (CInterfaceLocationIdentity)((Object)obj);
            return cInterfaceLocationIdentity.toString();
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            encoder.makeStringId(CInterfaceLocationIdentityBuiltIn.asString(obj), objectPath);
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            String string = CInterfaceLocationIdentityBuiltIn.asString(obj);
            encoder.writeString(stream, string);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            String encoded = decoder.readString(stream);
            return new CInterfaceLocationIdentity(encoded);
        }
    }

    public static class HostedSnippetReflectionProviderBuiltIn
    extends ObjectCopier.Builtin {
        private final SnippetReflectionProvider snippetReflectionProvider;

        protected HostedSnippetReflectionProviderBuiltIn(SnippetReflectionProvider snippetReflectionProvider) {
            super(SnippetReflectionProvider.class, new Class[]{HostedSnippetReflectionProvider.class});
            this.snippetReflectionProvider = snippetReflectionProvider;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return this.snippetReflectionProvider;
        }
    }

    public static class HostedOptionValuesBuiltIn
    extends ObjectCopier.Builtin {
        protected HostedOptionValuesBuiltIn() {
            super(HostedOptionValues.class, new Class[0]);
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return HostedOptionValues.singleton();
        }
    }

    public static class HostedMethodBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader svmImageLayerLoader;

        protected HostedMethodBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(HostedMethod.class, new Class[0]);
            this.svmImageLayerLoader = svmImageLayerLoader;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            stream.writePackedUnsignedInt(((HostedMethod)obj).getWrapped().getId());
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            AnalysisMethod method = this.svmImageLayerLoader.getAnalysisMethod(id);
            return this.svmImageLayerLoader.getHostedUniverse().lookup((JavaMethod)method);
        }
    }

    public static class HostedTypeBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader svmImageLayerLoader;

        protected HostedTypeBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(HostedType.class, new Class[]{HostedInstanceClass.class, HostedArrayClass.class});
            this.svmImageLayerLoader = svmImageLayerLoader;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            int id = ((HostedType)obj).getWrapped().getId();
            stream.writePackedUnsignedInt(id);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            AnalysisType type = this.svmImageLayerLoader.getAnalysisType(id);
            return this.svmImageLayerLoader.getHostedUniverse().lookup((JavaType)type);
        }
    }
}

