/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationArrayValue;
import com.oracle.svm.hosted.annotation.AnnotationClassValue;
import com.oracle.svm.hosted.annotation.AnnotationEnumValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import com.oracle.svm.hosted.annotation.AnnotationPrimitiveValue;
import com.oracle.svm.hosted.annotation.AnnotationStringValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import jdk.internal.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationType;

public abstract class AnnotationMemberValue {
    static AnnotationMemberValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        char tag = (char)buf.get();
        switch (tag) {
            case 'e': {
                return AnnotationEnumValue.extract(buf, cp, container, skip);
            }
            case 'c': {
                return AnnotationClassValue.extract(buf, cp, container, skip);
            }
            case 's': {
                return AnnotationStringValue.extract(buf, cp, skip);
            }
            case '@': {
                return AnnotationValue.extract(buf, cp, container, true, skip);
            }
            case '[': {
                return AnnotationArrayValue.extract(buf, cp, container, skip);
            }
        }
        return AnnotationPrimitiveValue.extract(buf, cp, tag, skip);
    }

    static AnnotationMemberValue from(Class<?> type, Object value) {
        if (type.isAnnotation()) {
            return new AnnotationValue((Annotation)value);
        }
        if (type.isEnum()) {
            return new AnnotationEnumValue((Enum)value);
        }
        if (type == Class.class) {
            return new AnnotationClassValue((Class)value);
        }
        if (type == String.class) {
            return new AnnotationStringValue((String)value);
        }
        if (type.isArray()) {
            return new AnnotationArrayValue(type.getComponentType(), value);
        }
        return new AnnotationPrimitiveValue(type, value);
    }

    public static AnnotationMemberValue getMemberValue(Annotation annotation, String memberName, Method memberAccessor, AnnotationType annotationType) {
        AnnotationMemberValue memberValue;
        try {
            memberAccessor.setAccessible(true);
            memberValue = AnnotationMemberValue.from(annotationType.memberTypes().get(memberName), memberAccessor.invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationMetadata.AnnotationExtractionError((Object)annotation, (Throwable)e);
        }
        return memberValue;
    }

    public List<Class<?>> getTypes() {
        return Collections.emptyList();
    }

    public abstract char getTag();

    public abstract Object get(Class<?> var1);
}

