/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ClassInclusionPolicy;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.CallChecker;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.PointsToCustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.IncompatibleClassChangeFallbackMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class NativeImagePointsToAnalysis
extends PointsToAnalysis
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final CustomTypeFieldHandler customTypeFieldHandler;
    private final CallChecker callChecker;
    private final ConcurrentHashMap<FallbackDescriptor, IncompatibleClassChangeFallbackMethod> fallbackMethods = new ConcurrentHashMap();

    public NativeImagePointsToAnalysis(OptionValues options, AnalysisUniverse universe, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, UnsupportedFeatures unsupportedFeatures, DebugContext debugContext, TimerCollection timerCollection, ClassInclusionPolicy classInclusionPolicy) {
        super(options, universe, universe.hostVM(), metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, unsupportedFeatures, debugContext, timerCollection, classInclusionPolicy);
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.dynamicHubInitializer = new DynamicHubInitializer(this);
        this.customTypeFieldHandler = new PointsToCustomTypeFieldHandler(this, metaAccess);
        this.callChecker = new CallChecker();
    }

    public boolean isCallAllowed(PointsToAnalysis bb, AnalysisMethod caller, AnalysisMethod target, BytecodePosition srcPosition) {
        return this.callChecker.isCallAllowed((BigBang)bb, caller, target, srcPosition);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod methodFlow, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return HostedConfiguration.instance().createMethodTypeFlowBuilder(bb, methodFlow, flowsGraph, graphKind);
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.customTypeFieldHandler.cleanupAfterAnalysis();
    }

    public void checkUserLimitations() {
        super.checkUserLimitations();
        UserLimitationsChecker.check(this);
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.customTypeFieldHandler.handleField(field);
    }

    public void injectFieldTypes(AnalysisField aField, List<AnalysisType> customTypes, boolean canBeNull) {
        this.customTypeFieldHandler.injectFieldTypes(aField, customTypes, canBeNull);
    }

    public void onTypeReachable(AnalysisType type) {
        this.postTask(d -> {
            type.getInitializeMetaDataTask().ensureDone();
            if (type.isInBaseLayer()) {
                this.universe.getImageLayerLoader().rescanHub(type, (Object)((SVMHost)this.hostVM).dynamicHub((ResolvedJavaType)type));
            }
            if (SubstrateOptions.includeAll()) {
                Stream.concat(Arrays.stream((ResolvedJavaField[])NativeImagePointsToAnalysis.getOrDefault((Object)type, t -> t.getInstanceFields(true), (Object)new AnalysisField[0])), Arrays.stream((ResolvedJavaField[])NativeImagePointsToAnalysis.getOrDefault((Object)type, AnalysisType::getStaticFields, (Object)new AnalysisField[0]))).map(OriginalFieldProvider::getJavaField).filter(field -> field != null && this.classInclusionPolicy.isFieldIncluded(field)).forEach(arg_0 -> ((ClassInclusionPolicy)this.classInclusionPolicy).includeField(arg_0));
                AnalysisMethod classInitializer = type.getClassInitializer();
                if (classInitializer != null && !ClassInitializationSupport.singleton().maybeInitializeAtBuildTime((ResolvedJavaType)type) && classInitializer.getCode() != null) {
                    this.classInclusionPolicy.includeMethod(classInitializer);
                }
            }
        });
    }

    public void initializeMetaData(AnalysisType type) {
        this.dynamicHubInitializer.initializeMetaData(this.universe.getHeapScanner(), type);
    }

    public static ResolvedJavaType toWrappedType(ResolvedJavaType type) {
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrapped();
        }
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrapped();
        }
        return type;
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return !SVMHost.isUnknownClass((ResolvedJavaType)type);
    }

    public AnalysisMethod fallbackResolveConcreteMethod(AnalysisType resolvingType, AnalysisMethod method) {
        if (!resolvingType.isAbstract() && !resolvingType.isInterface() && !method.isStatic() && method.getDeclaringClass().isAssignableFrom((ResolvedJavaType)resolvingType)) {
            if (method.getWrapped() instanceof IncompatibleClassChangeFallbackMethod) {
                return method;
            }
            IncompatibleClassChangeFallbackMethod uniqueFallbackMethod = this.fallbackMethods.computeIfAbsent(new FallbackDescriptor(resolvingType, method.getName(), (Signature)method.getSignature()), k -> new IncompatibleClassChangeFallbackMethod(resolvingType.getWrapped(), method.getWrapped(), NativeImagePointsToAnalysis.findResolutionError(resolvingType, method.getJavaMethod())));
            return this.getUniverse().lookup((JavaMethod)uniqueFallbackMethod);
        }
        return super.fallbackResolveConcreteMethod(resolvingType, method);
    }

    private static Class<? extends IncompatibleClassChangeError> findResolutionError(AnalysisType resolvingType, Executable searchMethod) {
        if (searchMethod != null) {
            Class<?>[] searchSignature = searchMethod.getParameterTypes();
            for (Class cur = resolvingType.getJavaClass(); cur != null; cur = cur.getSuperclass()) {
                Method found;
                try {
                    found = cur.getDeclaredMethod(searchMethod.getName(), searchSignature);
                }
                catch (Throwable ex) {
                    continue;
                }
                if (Modifier.isAbstract(found.getModifiers()) || Modifier.isPrivate(found.getModifiers()) || Modifier.isStatic(found.getModifiers())) {
                    return AbstractMethodError.class;
                }
                return IllegalAccessError.class;
            }
        }
        return AbstractMethodError.class;
    }

    record FallbackDescriptor(AnalysisType resolvingType, String name, Signature signature) {
    }
}

