/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.VMFeature;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class OpenTypeWorldFeature
implements InternalFeature {
    private final Set<AnalysisType> triggeredTypes = new HashSet<AnalysisType>();
    private final Set<AnalysisMethod> triggeredMethods = new HashSet<AnalysisMethod>();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !SubstrateOptions.useClosedTypeWorldHubLayout();
    }

    public void beforeUniverseBuilding(Feature.BeforeUniverseBuildingAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LayerTypeCheckInfo.class, (Object)new LayerTypeCheckInfo());
        }
    }

    public Set<Module> getBuilderModules() {
        Module m1;
        Module m0 = ((VMFeature)ImageSingletons.lookup(VMFeature.class)).getClass().getModule();
        return m0.equals(m1 = SVMHost.class.getModule()) ? Set.of(m0) : Set.of(m0, m1);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)access;
        for (AnalysisType aType : config.getUniverse().getTypes()) {
            if (!this.triggeredTypes.add(aType)) continue;
            aType.getOrCalculateOpenTypeWorldDispatchTableMethods();
            config.requireAnalysisIteration();
        }
        for (AnalysisMethod aMethod : config.getUniverse().getMethods()) {
            if (!this.triggeredMethods.add(aMethod) || aMethod.isStatic()) continue;
            aMethod.getIndirectCallTarget();
            config.requireAnalysisIteration();
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl impl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        for (HostedType type : impl.getUniverse().getTypes()) {
            DynamicHub hub = type.getHub();
            impl.registerAsImmutable(hub.getOpenTypeWorldTypeCheckSlots());
        }
    }

    public static int loadTypeInfo(Collection<HostedType> types) {
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            return ((LayerTypeCheckInfo)ImageSingletons.lookup(LayerTypeCheckInfo.class)).loadTypeID(types);
        }
        return 0;
    }

    public static void persistTypeInfo(Collection<HostedType> types) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            ((LayerTypeCheckInfo)ImageSingletons.lookup(LayerTypeCheckInfo.class)).persistTypeInfo(types);
        }
    }

    private static class LayerTypeCheckInfo
    implements LayeredImageSingleton {
        Map<Integer, TypeCheckInfo> identifierToTypeInfo = new HashMap<Integer, TypeCheckInfo>();
        int maxTypeID = 0;

        private LayerTypeCheckInfo() {
        }

        public int loadTypeID(Collection<HostedType> types) {
            ArrayList<Integer> usedIDs = new ArrayList<Integer>();
            for (HostedType type : types) {
                int identifierID = type.getWrapped().getId();
                TypeCheckInfo info = this.identifierToTypeInfo.get(identifierID);
                if (info == null) continue;
                usedIDs.add(info.typeID);
                type.loadTypeID(info.typeID);
            }
            return this.maxTypeID;
        }

        public void persistTypeInfo(Collection<HostedType> types) {
            for (HostedType type : types) {
                assert (type.getTypeID() != -1) : type;
                if (!type.getWrapped().isTrackedAcrossLayers()) continue;
                int identifierID = type.getWrapped().getId();
                int typeID = type.getTypeID();
                int numClassTypes = type.getNumClassTypes();
                int numInterfaceTypes = type.getNumInterfaceTypes();
                int[] typecheckSlots = type.getOpenTypeWorldTypeCheckSlots();
                TypeCheckInfo priorInfo = this.identifierToTypeInfo.get(identifierID);
                TypeCheckInfo newTypeInfo = new TypeCheckInfo(typeID, numClassTypes, numInterfaceTypes, typecheckSlots);
                if (priorInfo == null) {
                    this.identifierToTypeInfo.put(identifierID, newTypeInfo);
                    continue;
                }
                assert (newTypeInfo.equals(priorInfo)) : Assertions.errorMessage((Object[])new Object[]{"Mismatch for ", type, priorInfo, newTypeInfo, Arrays.toString(priorInfo.typecheckSlots), Arrays.toString(newTypeInfo.typecheckSlots)});
            }
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }

        private static String getTypeInfoKey(int id) {
            return String.format("TypeInfo-%s", id);
        }

        @Override
        public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
            List<Integer> typeIdentifierIds = this.identifierToTypeInfo.keySet().stream().sorted().toList();
            writer.writeIntList("typeIdentifierIds", typeIdentifierIds);
            writer.writeInt("maxTypeID", DynamicHubSupport.singleton().getMaxTypeId());
            for (int identifierID : typeIdentifierIds) {
                TypeCheckInfo typeInfo = this.identifierToTypeInfo.get(identifierID);
                assert (typeInfo != null);
                writer.writeIntList(LayerTypeCheckInfo.getTypeInfoKey(identifierID), typeInfo.toIntList());
            }
            return LayeredImageSingleton.PersistFlags.CREATE;
        }

        public static Object createFromLoader(ImageSingletonLoader loader) {
            LayerTypeCheckInfo info = new LayerTypeCheckInfo();
            info.maxTypeID = loader.readInt("maxTypeID");
            List<Integer> typeIdentifierIds = loader.readIntList("typeIdentifierIds");
            for (Integer identifierID : typeIdentifierIds) {
                TypeCheckInfo previous = info.identifierToTypeInfo.put(identifierID, TypeCheckInfo.fromIntList(loader.readIntList(LayerTypeCheckInfo.getTypeInfoKey(identifierID))));
                assert (previous == null) : previous;
            }
            return info;
        }
    }

    record TypeCheckInfo(int typeID, int numClassTypes, int numInterfaceTypes, int[] typecheckSlots) {
        private List<Integer> toIntList() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(this.typeID);
            list.add(this.numClassTypes);
            list.add(this.numInterfaceTypes);
            Arrays.stream(this.typecheckSlots).forEach(list::add);
            return list;
        }

        private static TypeCheckInfo fromIntList(List<Integer> list) {
            int typeID = list.get(0);
            int numClassTypes = list.get(1);
            int numInterfaceTypes = list.get(2);
            int[] typecheckSlots = list.subList(3, list.size()).stream().mapToInt(i -> i).toArray();
            return new TypeCheckInfo(typeID, numClassTypes, numInterfaceTypes, typecheckSlots);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeCheckInfo typeCheckInfo = (TypeCheckInfo)o;
            return this.typeID == typeCheckInfo.typeID && this.numClassTypes == typeCheckInfo.numClassTypes && this.numInterfaceTypes == typeCheckInfo.numInterfaceTypes && Arrays.equals(this.typecheckSlots, typeCheckInfo.typecheckSlots);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.typeID, this.numClassTypes, this.numInterfaceTypes);
            result = 31 * result + Arrays.hashCode(this.typecheckSlots);
            return result;
        }
    }
}

