/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.PreMainSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class InstrumentFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !Options.PremainClasses.getValue().values().isEmpty();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(ReflectionFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        FeatureImpl.AfterRegistrationAccessImpl a = (FeatureImpl.AfterRegistrationAccessImpl)access;
        ClassLoader cl = a.getImageClassLoader().getClassLoader();
        PreMainSupport support = new PreMainSupport();
        ImageSingletons.add(PreMainSupport.class, (Object)support);
        List premainClasses = Options.PremainClasses.getValue().values();
        for (String clazz : premainClasses) {
            InstrumentFeature.addPremainClass(support, cl, clazz);
        }
    }

    private static void addPremainClass(PreMainSupport support, ClassLoader cl, String premainClass) {
        try {
            Class<?> clazz = Class.forName(premainClass, false, cl);
            Method premain = InstrumentFeature.findPremainMethod(premainClass, clazz);
            ArrayList<Object> args = new ArrayList<Object>();
            args.add("");
            if (premain.getParameterCount() == 2) {
                args.add(new PreMainSupport.NativeImageNoOpRuntimeInstrumentation());
            }
            support.registerPremainMethod(premainClass, premain, args.toArray(new Object[0]));
        }
        catch (ClassNotFoundException e) {
            UserError.abort("Could not register agent premain method because class %s was not found. Please check your %s setting.", premainClass, SubstrateOptionsParser.commandArgument(Options.PremainClasses, ""));
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+25/src/java.instrument/share/classes/sun/instrument/InstrumentationImpl.java#L481-L548")
    private static Method findPremainMethod(String premainClass, Class<?> javaAgentClass) {
        try {
            return javaAgentClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return javaAgentClass.getDeclaredMethod("premain", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw UserError.abort("Could not register agent premain method: class %s neither declares 'premain(String, Instrumentation)' nor 'premain(String)'.", premainClass);
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> PremainClasses = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    }
}

