/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.util.LogUtils;
import jdk.vm.ci.meta.MetaUtil;

public final class ConfigurationTypeResolver {
    private final String configurationType;
    private final ImageClassLoader classLoader;

    public ConfigurationTypeResolver(String configurationType, ImageClassLoader classLoader) {
        this.configurationType = configurationType;
        this.classLoader = classLoader;
    }

    public Class<?> resolveType(String typeName) {
        return this.resolveType(typeName, true);
    }

    private Class<?> resolveType(String typeName, boolean warn) {
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        TypeResult<Class<?>> typeResult = this.classLoader.findClass(name);
        if (warn && !typeResult.isPresent()) {
            LogUtils.warning((String)"Could not resolve %s for %s.", (Object[])new Object[]{name, this.configurationType});
        }
        return typeResult.get();
    }
}

