/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.util.LogUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class AnalyzeJavaHomeAccessFeature
implements InternalFeature {
    private boolean javaHomeUsed = false;
    private Set<String> javaHomeUsageLocations = Collections.newSetFromMap(new ConcurrentSkipListMap());

    public static AnalyzeJavaHomeAccessFeature instance() {
        return (AnalyzeJavaHomeAccessFeature)ImageSingletons.lookup(AnalyzeJavaHomeAccessFeature.class);
    }

    public void setJavaHomeUsed() {
        this.javaHomeUsed = true;
    }

    public boolean getJavaHomeUsed() {
        return this.javaHomeUsed;
    }

    public void addJavaHomeUsageLocation(String location) {
        this.javaHomeUsageLocations.add(location);
    }

    public void printJavaHomeUsageLocations() {
        for (String location : this.javaHomeUsageLocations) {
            LogUtils.warning((String)("System.getProperty(\"java.home\") detected at " + location));
        }
        this.javaHomeUsageLocations.clear();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        AnalyzeJavaHomeAccessFeature.instance().printJavaHomeUsageLocations();
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> TrackJavaHomeAccess = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TrackJavaHomeAccessDetailed = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    TrackJavaHomeAccess.update(values, true);
                }
            }
        };
    }
}

