/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted.runtimecompilation;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.runtimecompilation.InvokeNode;
import com.oracle.svm.graal.hosted.runtimecompilation.MethodNode;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompilationCandidate;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompiledMethod;
import com.oracle.svm.graal.hosted.runtimecompilation.TraceInfo;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class CallTreeInfo {
    private final Map<AnalysisMethod, RuntimeCompiledMethod> runtimeCompilations;
    private Map<RuntimeCompilationCandidate, InvokeNode> runtimeCandidateMap;
    private Map<AnalysisMethod, MethodNode> analysisMethodMap;
    private boolean initialized = false;
    private static final String[] UNKNOWN_TRACE = new String[]{"Unknown"};
    private static final String[] EMPTY_STRING = new String[0];

    private CallTreeInfo(Map<AnalysisMethod, RuntimeCompiledMethod> runtimeCompilations) {
        this.runtimeCompilations = runtimeCompilations;
    }

    public Collection<RuntimeCompiledMethod> runtimeCompilations() {
        return this.runtimeCompilations.values();
    }

    public static CallTreeInfo create(AnalysisUniverse aUniverse, Map<AnalysisMethod, String> invalidForRuntimeCompilation) {
        HashMap<AnalysisMethod, RuntimeCompiledMethod> runtimeCompilations = new HashMap<AnalysisMethod, RuntimeCompiledMethod>();
        for (AnalysisMethod method : aUniverse.getMethods()) {
            AnalysisMethod rMethod = method.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            if (rMethod == null || !rMethod.isReachable() || invalidForRuntimeCompilation.containsKey(rMethod) || rMethod.getAnalyzedGraph() == null) continue;
            Set<AnalysisMethod> origInlinedMethods = rMethod.getAnalyzedGraph().getInlinedMethods().stream().map(inlinedMethod -> {
                AnalysisMethod orig = ((AnalysisMethod)inlinedMethod).getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                assert (orig != null);
                return orig;
            }).collect(Collectors.toUnmodifiableSet());
            RuntimeCompiledMethod previous = runtimeCompilations.put(rMethod, new RuntimeCompiledMethod(rMethod, origInlinedMethods));
            assert (previous == null) : previous;
        }
        return new CallTreeInfo(runtimeCompilations);
    }

    private void initializeCallerInfo() {
        this.analysisMethodMap = new HashMap<AnalysisMethod, MethodNode>();
        this.runtimeCandidateMap = new HashMap<RuntimeCompilationCandidate, InvokeNode>();
        for (RuntimeCompiledMethod runtimeCompilation : this.runtimeCompilations()) {
            AnalysisMethod method = runtimeCompilation.runtimeMethod;
            MethodNode callerMethodNode = this.analysisMethodMap.computeIfAbsent(method, MethodNode::new);
            for (InvokeInfo invokeInfo : method.getInvokes()) {
                AnalysisMethod invokeTarget = invokeInfo.getTargetMethod();
                boolean deoptInvokeTypeFlow = invokeInfo.isDeoptInvokeTypeFlow();
                if (deoptInvokeTypeFlow) {
                    assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)invokeTarget));
                    invokeTarget = invokeTarget.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                }
                assert (invokeTarget.isOriginalMethod());
                for (AnalysisMethod callee : invokeInfo.getAllCallees()) {
                    if (deoptInvokeTypeFlow || SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)callee)) {
                        MethodNode calleeMethodNode = this.analysisMethodMap.computeIfAbsent(callee.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD), MethodNode::new);
                        InvokeNode invoke = new InvokeNode(callerMethodNode, invokeInfo.getPosition());
                        calleeMethodNode.addCaller(invoke);
                        AnalysisMethod origCallee = callee.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                        assert (origCallee != null);
                        this.runtimeCandidateMap.putIfAbsent(new RuntimeCompilationCandidate(origCallee, invokeTarget), invoke);
                        continue;
                    }
                    if (!callee.isOriginalMethod() || callee.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) != null) continue;
                    this.runtimeCandidateMap.computeIfAbsent(new RuntimeCompilationCandidate(callee, invokeTarget), candidate -> new InvokeNode(callerMethodNode, invokeInfo.getPosition()));
                }
            }
        }
    }

    public void initialize(Set<AnalysisMethod> registeredRoots) {
        if (this.initialized) {
            return;
        }
        this.initializeCallerInfo();
        this.initialized = true;
        LinkedList<MethodNode> worklist = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.analysisMethodMap.values()) {
            if (!registeredRoots.contains(methodNode.method.getMultiMethod(MultiMethod.ORIGINAL_METHOD))) continue;
            worklist.add(methodNode);
            methodNode.trace = new TraceInfo(0, new BytecodePosition(null, (ResolvedJavaMethod)methodNode.method, -5), null);
        }
        while (!worklist.isEmpty()) {
            MethodNode callerMethodNode = (MethodNode)worklist.remove();
            TraceInfo callerTrace = callerMethodNode.trace;
            VMError.guarantee(callerTrace != null);
            for (InvokeInfo invokeInfo : callerMethodNode.method.getInvokes()) {
                boolean deoptInvokeTypeFlow = invokeInfo.isDeoptInvokeTypeFlow();
                if (deoptInvokeTypeFlow) continue;
                InvokeNode callerInvokeNode = null;
                for (AnalysisMethod callee : invokeInfo.getAllCallees()) {
                    MethodNode calleeMethodNode;
                    if (!SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)callee) || (calleeMethodNode = this.analysisMethodMap.get(callee)) == null || calleeMethodNode.trace != null) continue;
                    if (callerInvokeNode == null) {
                        callerInvokeNode = new InvokeNode(callerMethodNode, invokeInfo.getPosition());
                    }
                    worklist.add(calleeMethodNode);
                    calleeMethodNode.trace = new TraceInfo(callerTrace.level + 1, invokeInfo.getPosition(), callerInvokeNode);
                    callerTrace.addTraceTarget(calleeMethodNode);
                }
            }
        }
    }

    static String[] getCallTrace(CallTreeInfo callTreeInfo, AnalysisMethod method, Set<AnalysisMethod> registeredRuntimeCompilations) {
        callTreeInfo.initialize(registeredRuntimeCompilations);
        MethodNode methodNode = callTreeInfo.analysisMethodMap.get(method);
        if (methodNode == null) {
            return UNKNOWN_TRACE;
        }
        ArrayList<String> trace = new ArrayList<String>();
        CallTreeInfo.findCallTraceHelper(trace, methodNode);
        return trace.toArray(EMPTY_STRING);
    }

    static String[] getCallTrace(CallTreeInfo callTreeInfo, RuntimeCompilationCandidate candidate, Set<AnalysisMethod> registeredRuntimeCompilations) {
        callTreeInfo.initialize(registeredRuntimeCompilations);
        InvokeNode invokeNode = callTreeInfo.runtimeCandidateMap.get(candidate);
        if (invokeNode == null) {
            return UNKNOWN_TRACE;
        }
        ArrayList<String> trace = new ArrayList<String>();
        CallTreeInfo.findCallTraceHelper(trace, invokeNode.method);
        return trace.toArray(EMPTY_STRING);
    }

    private static void findCallTraceHelper(ArrayList<String> trace, MethodNode first) {
        if (first.trace != null) {
            MethodNode current = first;
            while (current != null) {
                MethodNode parent = null;
                InvokeNode caller = current.trace.invokeParent;
                if (caller != null) {
                    parent = caller.method;
                    trace.add(caller.position.toString());
                }
                current = parent;
            }
            trace.add("[Root]");
        } else {
            HashSet<MethodNode> covered = new HashSet<MethodNode>();
            MethodNode current = first;
            covered.add(current);
            while (current != null) {
                MethodNode parent = null;
                for (InvokeNode caller : current.getCallers()) {
                    if (!covered.add(caller.method)) continue;
                    parent = caller.method;
                    trace.add(caller.position.toString());
                    break;
                }
                current = parent;
            }
        }
    }

    public static void printCallTree(CallTreeInfo info, Set<AnalysisMethod> registeredRuntimeCompilations) {
        info.initialize(registeredRuntimeCompilations);
        System.out.println("depth;method;invoke position");
        for (MethodNode methodNode : info.analysisMethodMap.values()) {
            if (methodNode.trace == null || methodNode.trace.level != 0) continue;
            CallTreeInfo.printCallTreeNode(methodNode);
        }
    }

    private static void printCallTreeNode(MethodNode node) {
        TraceInfo trace = node.trace;
        StringBuilder indent = new StringBuilder();
        indent.append("  ".repeat(Math.max(0, trace.level)));
        indent.append(node.method.format("%H.%n"));
        System.out.format("%4d ; %-80s  ; %s%n", trace.level, indent, trace.position);
        for (MethodNode child : trace.getTraceTargets()) {
            CallTreeInfo.printCallTreeNode(child);
        }
    }

    public static void printDeepestPath(CallTreeInfo info, Set<AnalysisMethod> registeredRuntimeCompilations) {
        TraceInfo trace;
        InvokeNode call;
        info.initialize(registeredRuntimeCompilations);
        Optional<MethodNode> deepestNode = info.analysisMethodMap.values().stream().max(Comparator.comparingInt(t -> t.trace == null ? -1 : t.trace.level));
        if (deepestNode.isEmpty() || deepestNode.get().trace == null) {
            System.out.println("Could not find a trace");
            return;
        }
        MethodNode node = deepestNode.get();
        System.out.printf("Deepest level call tree path (%s calls):%n", node.trace.level);
        System.out.println("depth;method;invoke position");
        do {
            trace = node.trace;
            StringBuilder indent = new StringBuilder();
            indent.append("  ".repeat(Math.max(0, trace.level)));
            indent.append(node.method.format("%H.%n"));
            System.out.format("%4d ; %-80s  ; %s%n", trace.level, indent, trace.position);
        } while ((node = (call = trace.invokeParent) == null ? null : call.method) != null);
    }
}

