/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.hosted.FeatureImpl;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.core.CompilationWrapper;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DiagnosticsOutputDirectory;
import jdk.graal.compiler.debug.GlobalMetrics;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.FloatingGuardPhase;
import jdk.graal.compiler.phases.Speculative;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

public class TruffleRuntimeCompilationSupport {
    private RuntimeConfiguration runtimeConfig;
    private Suites fullOptimizationSuites;
    private Suites suitesWithoutSpeculation;
    private Suites suitesWithExplicitExceptions;
    private LIRSuites lirSuites;
    private Suites firstTierSuites;
    private LIRSuites firstTierLirSuites;
    private Providers firstTierProviders;
    @UnknownObjectField
    private SubstrateMethod[] methodsToCompile;
    @UnknownObjectField
    private byte[] graphEncoding;
    @UnknownObjectField
    private Object[] graphObjects;
    @UnknownObjectField
    private NodeClass<?>[] graphNodeTypes;
    protected Function<Providers, SubstrateBackend> runtimeBackendProvider;
    protected final GlobalMetrics metricValues = new GlobalMetrics();
    protected final DiagnosticsOutputDirectory outputDirectory = new DiagnosticsOutputDirectory((OptionValues)RuntimeOptionValues.singleton());
    protected final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);

    public DebugContext openDebugContext(OptionValues options, CompilationIdentifier compilationId, Object compilable, PrintStream logStream) {
        DebugContext.Description description = new DebugContext.Description(compilable, compilationId.toString(CompilationIdentifier.Verbosity.ID));
        return new DebugContext.Builder(options, this.runtimeConfig.getDebugHandlersFactories()).globalMetrics(this.metricValues).description(description).logStream(logStream).build();
    }

    public DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.compilationProblemsPerAction;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public TruffleRuntimeCompilationSupport() {
        this.runtimeBackendProvider = SubstrateBackendFactory.get()::newBackend;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setRuntimeConfig(RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, Suites firstTierSuites, LIRSuites firstTierLirSuites) {
        TruffleRuntimeCompilationSupport.get().runtimeConfig = runtimeConfig;
        TruffleRuntimeCompilationSupport.get().fullOptimizationSuites = suites;
        TruffleRuntimeCompilationSupport.get().suitesWithoutSpeculation = TruffleRuntimeCompilationSupport.getWithoutSpeculative(suites);
        TruffleRuntimeCompilationSupport.get().suitesWithExplicitExceptions = TruffleRuntimeCompilationSupport.getWithExplicitExceptions(suites);
        TruffleRuntimeCompilationSupport.get().lirSuites = lirSuites;
        TruffleRuntimeCompilationSupport.get().firstTierSuites = firstTierSuites;
        TruffleRuntimeCompilationSupport.get().firstTierLirSuites = firstTierLirSuites;
        TruffleRuntimeCompilationSupport.get().firstTierProviders = runtimeConfig.getBackendForNormalMethod().getProviders();
    }

    private static Suites getWithoutSpeculative(Suites s) {
        Suites effectiveSuites = s.copy();
        effectiveSuites.getHighTier().removeSubTypePhases(Speculative.class);
        effectiveSuites.getMidTier().removeSubTypePhases(Speculative.class);
        effectiveSuites.getLowTier().removeSubTypePhases(Speculative.class);
        return effectiveSuites;
    }

    private static Suites getWithExplicitExceptions(Suites s) {
        Suites effectiveSuites = s.copy();
        effectiveSuites.getHighTier().removeSubTypePhases(FloatingGuardPhase.class);
        effectiveSuites.getMidTier().removeSubTypePhases(FloatingGuardPhase.class);
        effectiveSuites.getLowTier().removeSubTypePhases(FloatingGuardPhase.class);
        effectiveSuites.getHighTier().removeSubTypePhases(Speculative.class);
        effectiveSuites.getMidTier().removeSubTypePhases(Speculative.class);
        effectiveSuites.getLowTier().removeSubTypePhases(Speculative.class);
        return effectiveSuites;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setMethodsToCompile(FeatureImpl.DuringAnalysisAccessImpl config, SubstrateMethod[] methodsToCompile) {
        boolean result = false;
        TruffleRuntimeCompilationSupport support = TruffleRuntimeCompilationSupport.get();
        if (!Arrays.equals(support.methodsToCompile, methodsToCompile)) {
            support.methodsToCompile = methodsToCompile;
            TruffleRuntimeCompilationSupport.rescan(config, (Object)methodsToCompile);
            result = true;
        }
        return result;
    }

    public static Suites getFullOptSuites() {
        return TruffleRuntimeCompilationSupport.get().fullOptimizationSuites;
    }

    public static Suites getWithoutSpeculativeSuites() {
        return TruffleRuntimeCompilationSupport.get().suitesWithoutSpeculation;
    }

    public static Suites getExplicitExceptionSuites() {
        return TruffleRuntimeCompilationSupport.get().suitesWithExplicitExceptions;
    }

    public static Suites getMatchingSuitesForGraph(StructuredGraph graph) {
        Suites s = TruffleRuntimeCompilationSupport.getFullOptSuites();
        if (graph.getSpeculationLog() == null) {
            s = TruffleRuntimeCompilationSupport.getWithoutSpeculativeSuites();
        }
        if (graph.getGraphState().isExplicitExceptionsNoDeopt()) {
            s = TruffleRuntimeCompilationSupport.getExplicitExceptionSuites();
        }
        return s;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setGraphEncoding(Feature.FeatureAccess a, byte[] graphEncoding, Object[] graphObjects, NodeClass<?>[] graphNodeTypes) {
        TruffleRuntimeCompilationSupport support = TruffleRuntimeCompilationSupport.get();
        if (support.graphObjects == null && graphObjects.length == 0) {
            assert (graphEncoding.length == 0);
            assert (graphNodeTypes.length == 0);
            return false;
        }
        boolean result = false;
        if (!Arrays.equals(support.graphEncoding, graphEncoding)) {
            support.graphEncoding = graphEncoding;
            result = true;
        }
        if (!Arrays.deepEquals(support.graphObjects, graphObjects)) {
            support.graphObjects = graphObjects;
            TruffleRuntimeCompilationSupport.rescan(a, (Object)graphObjects);
            result = true;
        }
        if (!Arrays.equals(support.graphNodeTypes, graphNodeTypes)) {
            support.graphNodeTypes = graphNodeTypes;
            TruffleRuntimeCompilationSupport.rescan(a, graphNodeTypes);
            result = true;
        }
        return result;
    }

    private static void rescan(Feature.FeatureAccess a, Object object) {
        if (a instanceof FeatureImpl.DuringAnalysisAccessImpl) {
            FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
            TruffleRuntimeCompilationSupport.rescan(access.getUniverse(), object);
        }
    }

    public static void rescan(AnalysisUniverse universe, Object object) {
        universe.getHeapScanner().rescanObject(object);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerImmutableObjects(Feature.BeforeHeapLayoutAccess access) {
        access.registerAsImmutable((Object)TruffleRuntimeCompilationSupport.get().graphEncoding);
        access.registerAsImmutable((Object)TruffleRuntimeCompilationSupport.get().graphObjects);
        access.registerAsImmutable(TruffleRuntimeCompilationSupport.get().graphNodeTypes);
    }

    public static TruffleRuntimeCompilationSupport get() {
        return (TruffleRuntimeCompilationSupport)ImageSingletons.lookup(TruffleRuntimeCompilationSupport.class);
    }

    public static RuntimeConfiguration getRuntimeConfig() {
        return TruffleRuntimeCompilationSupport.get().runtimeConfig;
    }

    public static LIRSuites getLIRSuites() {
        return TruffleRuntimeCompilationSupport.get().lirSuites;
    }

    public static Suites getFirstTierSuites() {
        return TruffleRuntimeCompilationSupport.get().firstTierSuites;
    }

    public static LIRSuites getFirstTierLirSuites() {
        return TruffleRuntimeCompilationSupport.get().firstTierLirSuites;
    }

    public static Providers getFirstTierProviders() {
        return TruffleRuntimeCompilationSupport.get().firstTierProviders;
    }

    public static SubstrateMethod[] getMethodsToCompile() {
        return TruffleRuntimeCompilationSupport.get().methodsToCompile;
    }

    public static EncodedGraph encodedGraph(SharedRuntimeMethod method, boolean trackNodeSourcePosition) {
        int startOffset = method.getEncodedGraphStartOffset();
        if (startOffset == -1) {
            return null;
        }
        return new EncodedGraph(TruffleRuntimeCompilationSupport.get().graphEncoding, startOffset, TruffleRuntimeCompilationSupport.get().graphObjects, TruffleRuntimeCompilationSupport.get().graphNodeTypes, null, null, false, trackNodeSourcePosition);
    }

    public static StructuredGraph decodeGraph(DebugContext debug, String name, CompilationIdentifier compilationId, SharedRuntimeMethod method, StructuredGraph caller) {
        EncodedGraph encodedGraph = TruffleRuntimeCompilationSupport.encodedGraph(method, false);
        if (encodedGraph == null) {
            return null;
        }
        boolean isSubstitution = method.isSnippet();
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).name(name).method((ResolvedJavaMethod)method).recordInlinedMethods(false).compilationId(compilationId).setIsSubstitution(isSubstitution).speculationLog(caller != null ? caller.getSpeculationLog() : null).build();
        GraphDecoder decoder = new GraphDecoder(ConfigurationValues.getTarget().arch, graph);
        decoder.decode(encodedGraph);
        return graph;
    }

    public static Function<Providers, SubstrateBackend> getRuntimeBackendProvider() {
        return TruffleRuntimeCompilationSupport.get().runtimeBackendProvider;
    }
}

