/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.CounterGroupList;
import com.oracle.svm.core.util.CounterSupport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class CounterFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(CounterGroupList.class, (Object)new CounterGroupList());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        CounterGroupList counterGroupList = (CounterGroupList)ImageSingletons.lookup(CounterGroupList.class);
        List<Counter.Group> candidateGroups = counterGroupList.getGroups();
        ArrayList<Counter.Group> enabledGroups = new ArrayList<Counter.Group>(candidateGroups.size());
        for (Counter.Group group : candidateGroups) {
            group.enabled = group.enabledOption.getValue();
            if (!group.enabled) continue;
            enabledGroups.add(group);
        }
        if (enabledGroups.size() > 0) {
            enabledGroups.sort(Comparator.comparing(g -> g.name));
            ImageSingletons.add(CounterSupport.class, (Object)new CounterSupport(enabledGroups.toArray(new Counter.Group[0])));
            RuntimeSupport.getRuntimeSupport().addShutdownHook(CounterSupport.shutdownHook());
        }
    }
}

