/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

public final class PthreadConditionUtils {
    private static final int MAX_SECS = 100000000;

    private PthreadConditionUtils() {
    }

    @Fold
    static boolean useMonotonicClockForRelativeWait() {
        return Platform.includedIn(Platform.LINUX.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int initConditionWithAbsoluteTime(Pthread.pthread_cond_t cond) {
        return Pthread.pthread_cond_init(cond, (Pthread.pthread_condattr_t)WordFactory.nullPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int initConditionWithRelativeTime(Pthread.pthread_cond_t cond) {
        Pthread.pthread_condattr_t attr = (Pthread.pthread_condattr_t)StackValue.get(Pthread.pthread_condattr_t.class);
        int status = Pthread.pthread_condattr_init(attr);
        if (status == 0) {
            try {
                if (PthreadConditionUtils.useMonotonicClockForRelativeWait() && (status = LinuxPthread.pthread_condattr_setclock(attr, LinuxTime.CLOCK_MONOTONIC())) != 0) {
                    int n = status;
                    return n;
                }
                int n = Pthread.pthread_cond_init(cond, attr);
                return n;
            }
            finally {
                status = Pthread.pthread_condattr_destroy(attr);
                assert (status == 0);
            }
        }
        return status;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fillTimespec(Time.timespec result, long durationNanos) {
        PthreadConditionUtils.fillTimespec(result, durationNanos, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fillTimespec(Time.timespec result, long time, boolean isAbsolute) {
        assert (time > 0L) : "must not be called otherwise";
        int clock = PthreadConditionUtils.getClock(isAbsolute);
        Time.timespec now = (Time.timespec)StackValue.get(Time.timespec.class);
        int status = PosixUtils.clock_gettime(clock, now);
        PosixUtils.checkStatusIs0(status, "PthreadConditionUtils.fillTimespec: clock_gettime failed.");
        if (!isAbsolute) {
            PthreadConditionUtils.calcRelTime(result, time, now);
        } else {
            PthreadConditionUtils.unpackAbsTime(result, time, now);
        }
        assert (result.tv_sec() >= 0L) : "tv_sec < 0";
        assert (result.tv_sec() <= now.tv_sec() + 100000000L) : "tv_sec > max_secs";
        assert (result.tv_nsec() >= 0L) : "tv_nsec < 0";
        assert (result.tv_nsec() < 1000000000L) : "tv_nsec >= nanosPerSecond";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getClock(boolean isAbsolute) {
        if (!isAbsolute && PthreadConditionUtils.useMonotonicClockForRelativeWait()) {
            return LinuxTime.CLOCK_MONOTONIC();
        }
        return Time.CLOCK_REALTIME();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void calcRelTime(Time.timespec absTime, long timeoutNanos, Time.timespec now) {
        long seconds = timeoutNanos / 1000000000L;
        long nanos = timeoutNanos % 1000000000L;
        if (seconds >= 100000000L) {
            absTime.set_tv_sec(now.tv_sec() + 100000000L);
            absTime.set_tv_nsec(0L);
        } else {
            absTime.set_tv_sec(now.tv_sec() + seconds);
            if ((nanos += now.tv_nsec()) >= 1000000000L) {
                absTime.set_tv_sec(absTime.tv_sec() + 1L);
                nanos -= 1000000000L;
            }
            absTime.set_tv_nsec(nanos);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void unpackAbsTime(Time.timespec absTime, long deadlineMillis, Time.timespec now) {
        long seconds = deadlineMillis / 1000L;
        long millis = deadlineMillis % 1000L;
        long maxSecs = now.tv_sec() + 100000000L;
        if (seconds >= maxSecs) {
            absTime.set_tv_sec(maxSecs);
            absTime.set_tv_nsec(0L);
        } else {
            absTime.set_tv_sec(seconds);
            absTime.set_tv_nsec(millis * 1000000L);
        }
    }
}

