/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jvmti.JvmtiAgents;
import com.oracle.svm.core.jvmti.JvmtiEnvs;
import com.oracle.svm.core.jvmti.JvmtiEvents;
import com.oracle.svm.core.jvmti.headers.JvmtiPhase;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JvmtiSupport {
    private JvmtiPhase phase = JvmtiPhase.JVMTI_PHASE_LIVE;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JvmtiSupport() {
    }

    @Fold
    public static JvmtiSupport singleton() {
        return (JvmtiSupport)ImageSingletons.lookup(JvmtiSupport.class);
    }

    public JvmtiPhase getPhase() {
        return this.phase;
    }

    public void setPhase(JvmtiPhase phase) {
        this.phase = phase;
    }

    public static RuntimeSupport.Hook initializationHook() {
        return firstIsolate -> {
            JvmtiAgents.singleton().load();
            JvmtiEvents.postVMInit();
            JvmtiEvents.postVMStart();
        };
    }

    public static RuntimeSupport.Hook teardownHook() {
        return firstIsolate -> {
            JvmtiEvents.postVMDeath();
            JvmtiSupport.singleton().setPhase(JvmtiPhase.JVMTI_PHASE_DEAD);
            JvmtiAgents.singleton().unload();
            JvmtiEnvs.singleton().teardown();
        };
    }
}

