/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.oldobject;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.oldobject.JfrOldObject;
import com.oracle.svm.core.jfr.oldobject.JfrOldObjectSampler;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import jdk.internal.misc.Unsafe;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import org.graalvm.word.UnsignedWord;

public final class JfrOldObjectProfiler {
    private static final int DEFAULT_SAMPLER_SIZE = 256;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long LOCK_OFFSET = U.objectFieldOffset(JfrOldObjectProfiler.class, "lock");
    private volatile int lock;
    private int queueSize = 256;
    private JfrOldObjectSampler sampler;

    public void configure(int oldObjectQueueSize) {
        if (Logger.shouldLog(LogTag.JFR, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR, LogLevel.DEBUG, "Initialize old object sampler: old-object-queue-size=" + oldObjectQueueSize);
        }
        this.queueSize = oldObjectQueueSize;
    }

    public void reset() {
        this.sampler = new JfrOldObjectSampler(this.queueSize);
    }

    public void teardown() {
        this.sampler = null;
    }

    @Uninterruptible(reason="Needed for shouldEmit().")
    public boolean sample(Object obj, UnsignedWord allocatedSize, int arrayLength) {
        if (!JfrEvent.OldObjectSample.shouldEmit()) {
            return false;
        }
        return this.sample0(obj, allocatedSize, arrayLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not safepoint while holding the lock.")
    private boolean sample0(Object obj, UnsignedWord allocatedSize, int arrayLength) {
        assert (allocatedSize.aboveThan(0));
        assert (arrayLength >= 0 || arrayLength == Integer.MIN_VALUE);
        boolean success = JavaSpinLockUtils.tryLock(this, LOCK_OFFSET);
        if (!success) {
            return false;
        }
        try {
            boolean bl = this.sampler.sample(obj, allocatedSize, arrayLength);
            return bl;
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not safepoint while holding the lock.")
    public void emit(long cutoff, boolean emitAll, boolean skipBFS) {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            this.sampler.emit(cutoff, emitAll, skipBFS);
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    public static class TestingBackdoor {
        public static JfrOldObject getOldestObject(JfrOldObjectProfiler profiler) {
            return profiler.sampler.getOldestObject();
        }

        public static boolean sample(JfrOldObjectProfiler profiler, Object obj, UnsignedWord allocatedSize, int arrayLength) {
            return profiler.sample0(obj, allocatedSize, arrayLength);
        }
    }
}

