/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrChunkNoWriter
implements JfrChunkWriter {
    private static final String ERROR_MESSAGE = "JfrChunkWriter does not permit write operations, so reaching this method during runtime indicates a semantic error in the code.";

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrChunkNoWriter() {
    }

    @Override
    public void initialize(long maxChunkSize) {
    }

    @Override
    public JfrChunkWriter lock() {
        return this;
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOpenFile() {
        return false;
    }

    @Override
    public void unlock() {
    }

    @Override
    public long getChunkStartNanos() {
        return -1L;
    }

    @Override
    public void setFilename(String filename) {
    }

    @Override
    public void maybeOpenFile() {
    }

    @Override
    public void openFile(String outputFile) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void write(JfrBuffer buffer) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void flush() {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void markChunkFinal() {
    }

    @Override
    public void closeFile() {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void setMetadata(byte[] bytes) {
    }

    @Override
    public boolean shouldRotateDisk() {
        return false;
    }

    @Override
    public long beginEvent() {
        throw VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void endEvent(long start) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeBoolean(boolean value) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeByte(byte value) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeBytes(byte[] values) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeCompressedInt(int value) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writePaddedInt(long value) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeCompressedLong(long value) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }

    @Override
    public void writeString(String str) {
        VMError.shouldNotReachHere(ERROR_MESSAGE);
    }
}

