/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.GCRelatedMXBeans;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.management.JmxIncluded;
import com.oracle.svm.core.jdk.management.SubstrateClassLoadingMXBean;
import com.oracle.svm.core.jdk.management.SubstrateCompilationMXBean;
import com.oracle.svm.core.jdk.management.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.jdk.management.Target_com_sun_management_internal_OperatingSystemImpl;
import com.oracle.svm.core.jdk.management.Target_jdk_management_jfr_FlightRecorderMXBeanImpl;
import com.oracle.svm.core.jdk.management.Target_sun_management_BaseOperatingSystemImpl;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.sun.management.ThreadMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.management.StandardMBean;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

public final class ManagementSupport
implements ThreadListener {
    private static final Class<? extends PlatformManagedObject> FLIGHT_RECORDER_MX_BEAN_CLASS = ManagementSupport.getFlightRecorderMXBeanClass();
    private final MXBeans mxBeans = new MXBeans();
    private final SubstrateThreadMXBean threadMXBean;
    private OperatingSystemMXBean osMXBean;
    private PlatformManagedObject flightRecorderMXBean;
    private MBeanServer platformMBeanServer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ManagementSupport(SubstrateRuntimeMXBean runtimeMXBean, SubstrateThreadMXBean threadMXBean) {
        SubstrateClassLoadingMXBean classLoadingMXBean = new SubstrateClassLoadingMXBean();
        SubstrateCompilationMXBean compilationMXBean = new SubstrateCompilationMXBean();
        this.threadMXBean = threadMXBean;
        this.mxBeans.addSingleton(ClassLoadingMXBean.class, classLoadingMXBean);
        this.mxBeans.addSingleton(CompilationMXBean.class, compilationMXBean);
        this.mxBeans.addSingleton(RuntimeMXBean.class, runtimeMXBean);
        this.mxBeans.addSingleton(ThreadMXBean.class, threadMXBean);
        this.mxBeans.addSingleton(ManagementSupport.getOsMXBeanInterface(), this::getOsMXBean);
        if (FLIGHT_RECORDER_MX_BEAN_CLASS != null) {
            this.mxBeans.addSingleton(FLIGHT_RECORDER_MX_BEAN_CLASS, this::getFlightRecorderMXBean);
        }
    }

    @Fold
    public static ManagementSupport getSingleton() {
        return (ManagementSupport)ImageSingletons.lookup(ManagementSupport.class);
    }

    public <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        Object result = this.getPlatformMXBeans0(clazz);
        if (result == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        if (result instanceof List) {
            throw new IllegalArgumentException(clazz.getName() + " can have more than one instance");
        }
        return (T)((PlatformManagedObject)clazz.cast(ManagementSupport.resolveMXBean(result)));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PlatformManagedObject getPlatformMXBeanRaw(Class<? extends PlatformManagedObject> clazz) {
        return (PlatformManagedObject)this.getPlatformMXBeans0(clazz);
    }

    public <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) {
        Object result = this.getPlatformMXBeans0(clazz);
        if (result == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        if (result instanceof List) {
            return (List)result;
        }
        return Collections.singletonList((PlatformManagedObject)clazz.cast(ManagementSupport.resolveMXBean(result)));
    }

    private Object getPlatformMXBeans0(Class<? extends PlatformManagedObject> clazz) {
        Object result = this.mxBeans.get(clazz);
        if (result == null) {
            result = GCRelatedMXBeans.mxBeans().get(clazz);
        } else assert (GCRelatedMXBeans.mxBeans().get(clazz) == null);
        return result;
    }

    public Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        HashSet<Class<? extends PlatformManagedObject>> result = new HashSet<Class<? extends PlatformManagedObject>>(this.mxBeans.classToObject.keySet());
        result.addAll(GCRelatedMXBeans.mxBeans().classToObject.keySet());
        return Collections.unmodifiableSet(result);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<PlatformManagedObject> getPlatformManagedObjects() {
        Set<PlatformManagedObject> result = Collections.newSetFromMap(new IdentityHashMap());
        result.addAll(this.mxBeans.objects);
        result.addAll(GCRelatedMXBeans.mxBeans().objects);
        return result;
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed before the thread is fully started.")
    public void beforeThreadStart(IsolateThread isolateThread, Thread javaThread) {
        this.threadMXBean.noteThreadStart(javaThread);
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed after Thread.exit.")
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        this.threadMXBean.noteThreadFinish(javaThread);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isAllowedPlatformManagedObject(PlatformManagedObject object) {
        if (this.mxBeans.contains(object) || GCRelatedMXBeans.mxBeans().contains(object)) {
            return true;
        }
        for (Class<? extends PlatformManagedObject> clazz : ManagementFactory.getPlatformManagementInterfaces()) {
            if (!clazz.isInstance(object) || !ManagementFactory.getPlatformMXBeans(clazz).contains(object)) continue;
            return false;
        }
        return true;
    }

    public synchronized MBeanServer getPlatformMBeanServer() {
        if (this.platformMBeanServer == null) {
            this.platformMBeanServer = MBeanServerFactory.createMBeanServer();
            for (PlatformManagedObject platformManagedObject : this.mxBeans.objects) {
                ManagementSupport.addMXBean(this.platformMBeanServer, ManagementSupport.resolveMXBean(platformManagedObject));
            }
            for (PlatformManagedObject platformManagedObject : GCRelatedMXBeans.mxBeans().objects) {
                ManagementSupport.addMXBean(this.platformMBeanServer, ManagementSupport.resolveMXBean(platformManagedObject));
            }
        }
        return this.platformMBeanServer;
    }

    private static PlatformManagedObject resolveMXBean(Object object) {
        PlatformManagedObject platformManagedObject;
        assert (object instanceof PlatformManagedObject);
        if (object instanceof PlatformManagedObjectSupplier) {
            PlatformManagedObjectSupplier pmos = (PlatformManagedObjectSupplier)object;
            platformManagedObject = (PlatformManagedObject)pmos.get();
        } else {
            platformManagedObject = (PlatformManagedObject)object;
        }
        return platformManagedObject;
    }

    private static void addMXBean(MBeanServer mbs, PlatformManagedObject pmo) {
        if (pmo == null) {
            return;
        }
        ObjectName oname = pmo.getObjectName();
        DynamicMBean dmbean = pmo instanceof DynamicMBean ? (DynamicMBean)DynamicMBean.class.cast(pmo) : (pmo instanceof NotificationEmitter ? new StandardEmitterMBean(pmo, null, true, (NotificationEmitter)((Object)pmo)) : new StandardMBean(pmo, null, true));
        try {
            mbs.registerMBean(dmbean, oname);
        }
        catch (JMException ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized OperatingSystemMXBean getOsMXBean() {
        if (this.osMXBean == null) {
            Object osMXBeanImpl = Platform.includedIn(InternalPlatform.PLATFORM_JNI.class) ? new Target_com_sun_management_internal_OperatingSystemImpl(null) : new Target_sun_management_BaseOperatingSystemImpl(null);
            this.osMXBean = SubstrateUtil.cast(osMXBeanImpl, OperatingSystemMXBean.class);
        }
        return this.osMXBean;
    }

    private synchronized PlatformManagedObject getFlightRecorderMXBean() {
        if (!HasJfrSupport.get() || !JmxIncluded.get()) {
            return null;
        }
        if (this.flightRecorderMXBean == null) {
            this.flightRecorderMXBean = SubstrateUtil.cast(new Target_jdk_management_jfr_FlightRecorderMXBeanImpl(), PlatformManagedObject.class);
        }
        return this.flightRecorderMXBean;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Class<? extends PlatformManagedObject> getFlightRecorderMXBeanClass() {
        Optional<Module> jfrModule = ModuleLayer.boot().findModule("jdk.management.jfr");
        if (jfrModule.isPresent()) {
            ManagementSupport.class.getModule().addReads(jfrModule.get());
            try {
                return Class.forName("jdk.management.jfr.FlightRecorderMXBean", false, Object.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Class<? extends PlatformManagedObject> getOsMXBeanInterface() {
        if (Platform.includedIn(InternalPlatform.PLATFORM_JNI.class)) {
            return Platform.includedIn(Platform.WINDOWS.class) ? com.sun.management.OperatingSystemMXBean.class : UnixOperatingSystemMXBean.class;
        }
        return OperatingSystemMXBean.class;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean verifyNoOverlappingMxBeans() {
        HashSet<Class<? extends PlatformManagedObject>> overlapping = new HashSet<Class<? extends PlatformManagedObject>>(this.mxBeans.classToObject.keySet());
        overlapping.retainAll(GCRelatedMXBeans.mxBeans().classToObject.keySet());
        return overlapping.isEmpty();
    }

    public static class MXBeans {
        private final Map<Class<? extends PlatformManagedObject>, Object> classToObject = new HashMap<Class<? extends PlatformManagedObject>, Object>();
        private final Set<PlatformManagedObject> objects = Collections.newSetFromMap(new IdentityHashMap());

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public MXBeans() {
        }

        public Object get(Class<? extends PlatformManagedObject> clazz) {
            return this.classToObject.get(clazz);
        }

        public boolean contains(PlatformManagedObject object) {
            return this.objects.contains(object);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void addSingleton(Class<? extends PlatformManagedObject> clazz, PlatformManagedObject object) {
            if (!clazz.isInterface()) {
                throw UserError.abort("Key for registration of a PlatformManagedObject must be an interface", new Object[0]);
            }
            for (Class<?> superinterface : clazz.getInterfaces()) {
                if (superinterface == PlatformManagedObject.class || !PlatformManagedObject.class.isAssignableFrom(superinterface)) continue;
                this.addSingleton(superinterface, object);
            }
            Object existing = this.classToObject.get(clazz);
            if (existing != null) {
                throw UserError.abort("PlatformManagedObject already registered: %s", clazz.getName());
            }
            this.classToObject.put(clazz, object);
            this.objects.add(object);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void addList(Class<? extends PlatformManagedObject> clazz, List<? extends PlatformManagedObject> beans) {
            if (!clazz.isInterface()) {
                throw UserError.abort("Key for registration of a PlatformManagedObject must be an interface", new Object[0]);
            }
            for (Class<?> superinterface : clazz.getInterfaces()) {
                if (superinterface == PlatformManagedObject.class || !PlatformManagedObject.class.isAssignableFrom(superinterface)) continue;
                this.addList(superinterface, beans);
            }
            Object existing = this.classToObject.get(clazz);
            if (existing instanceof PlatformManagedObject) {
                throw UserError.abort("PlatformManagedObject already registered as a singleton: %s", clazz.getName());
            }
            ArrayList<? extends PlatformManagedObject> newList = new ArrayList<PlatformManagedObject>();
            if (existing != null) {
                newList.addAll((List)existing);
            }
            newList.addAll(beans);
            newList.trimToSize();
            this.classToObject.put(clazz, Collections.unmodifiableList(newList));
            this.objects.addAll(beans);
        }
    }

    public static interface PlatformManagedObjectSupplier
    extends Supplier<PlatformManagedObject>,
    PlatformManagedObject {
        @Override
        default public ObjectName getObjectName() {
            throw VMError.shouldNotReachHereOverrideInChild();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class JdkManagementJfrModulePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return FLIGHT_RECORDER_MX_BEAN_CLASS != null;
        }
    }
}

