/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.localization.substitutions.InternalLocaleBuilderUtil;
import java.util.ArrayList;
import java.util.List;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.LocaleUtils;
import sun.util.locale.StringTokenIterator;

@TargetClass(value=InternalLocaleBuilder.class)
public final class Target_sun_util_locale_InternalLocaleBuilder {
    @Alias
    public native Target_sun_util_locale_InternalLocaleBuilder clearExtensions();

    @Alias
    private native Target_sun_util_locale_InternalLocaleBuilder setExtensions(List<String> var1, String var2);

    @Substitute
    public Target_sun_util_locale_InternalLocaleBuilder setExtensions(String subtagsParam) throws LocaleSyntaxException {
        int start;
        String s;
        if (LocaleUtils.isEmpty(subtagsParam)) {
            this.clearExtensions();
            return this;
        }
        String subtags = InternalLocaleBuilderUtil.replaceAll(subtagsParam, "_".charAt(0), "-".charAt(0));
        StringTokenIterator itr = new StringTokenIterator(subtags, "-");
        ArrayList<String> extensions = null;
        String privateuse = null;
        int parsed = 0;
        while (!itr.isDone() && LanguageTag.isExtensionSingleton(s = itr.current())) {
            start = itr.currentStart();
            String singleton = s;
            StringBuilder sb = new StringBuilder(singleton);
            itr.next();
            while (!itr.isDone() && LanguageTag.isExtensionSubtag(s = itr.current())) {
                sb.append("-").append(s);
                parsed = itr.currentEnd();
                itr.next();
            }
            if (parsed < start) {
                throw new LocaleSyntaxException("Incomplete extension '" + singleton + "'", start);
            }
            if (extensions == null) {
                extensions = new ArrayList<String>(4);
            }
            extensions.add(sb.toString());
        }
        if (!itr.isDone() && LanguageTag.isPrivateusePrefix(s = itr.current())) {
            start = itr.currentStart();
            StringBuilder sb = new StringBuilder(s);
            itr.next();
            while (!itr.isDone() && LanguageTag.isPrivateuseSubtag(s = itr.current())) {
                sb.append("-").append(s);
                parsed = itr.currentEnd();
                itr.next();
            }
            if (parsed <= start) {
                throw new LocaleSyntaxException("Incomplete privateuse:" + subtags.substring(start), start);
            }
            privateuse = sb.toString();
        }
        if (!itr.isDone()) {
            throw new LocaleSyntaxException("Ill-formed extension subtags:" + subtags.substring(itr.currentStart()), itr.currentStart());
        }
        return this.setExtensions(extensions, privateuse);
    }
}

