/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.util.function.BooleanSupplier;
import jdk.internal.util.StaticProperty;

@Substitute
@TargetClass(value=StaticProperty.class)
final class Target_jdk_internal_util_StaticProperty {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_LANGUAGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_LANGUAGE_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_LANGUAGE_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_SCRIPT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_SCRIPT_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_SCRIPT_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_COUNTRY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_COUNTRY_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_COUNTRY_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_VARIANT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_VARIANT_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_VARIANT_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_EXTENSIONS;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_EXTENSIONS_DISPLAY;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_EXTENSIONS_FORMAT;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String USER_REGION;

    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return SystemPropertiesSupport.singleton().savedProperties.get("java.home");
    }

    @Substitute
    private static String userHome() {
        return SystemPropertiesSupport.singleton().userHome();
    }

    @Substitute
    private static String userDir() {
        return SystemPropertiesSupport.singleton().userDir();
    }

    @Substitute
    private static String userName() {
        return SystemPropertiesSupport.singleton().userName();
    }

    @Substitute
    private static String javaIoTmpDir() {
        return SystemPropertiesSupport.singleton().javaIoTmpDir();
    }

    @Substitute
    private static String javaLibraryPath() {
        return SystemPropertiesSupport.singleton().javaLibraryPath();
    }

    @Substitute
    private static String sunBootLibraryPath() {
        String value = SystemPropertiesSupport.singleton().savedProperties.get("sun.boot.library.path");
        return value == null ? "" : value;
    }

    @Substitute
    private static String jdkSerialFilter() {
        return SystemPropertiesSupport.singleton().savedProperties.get("jdk.serialFilter");
    }

    @Substitute
    @TargetElement(onlyWith={StaticPropertyJdkSerialFilterFactoryAvailable.class})
    private static String jdkSerialFilterFactory() {
        return SystemPropertiesSupport.singleton().savedProperties.get("jdk.serialFilterFactory");
    }

    @Substitute
    public static String nativeEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("native.encoding");
    }

    @Substitute
    public static String fileEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("file.encoding");
    }

    @Substitute
    public static String javaPropertiesDate() {
        return SystemPropertiesSupport.singleton().savedProperties.getOrDefault("java.properties.date", null);
    }

    @Substitute
    public static String jnuEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("sun.jnu.encoding");
    }

    @Substitute
    public static String javaLocaleUseOldISOCodes() {
        return SystemPropertiesSupport.singleton().savedProperties.getOrDefault("java.locale.useOldISOCodes", "");
    }

    static {
        if (!SubstrateUtil.HOSTED) {
            USER_LANGUAGE = SystemPropertiesSupport.singleton().getSavedProperty("user.language", "en");
            USER_LANGUAGE_DISPLAY = SystemPropertiesSupport.singleton().getSavedProperty("user.language.display", USER_LANGUAGE);
            USER_LANGUAGE_FORMAT = SystemPropertiesSupport.singleton().getSavedProperty("user.script.format", USER_LANGUAGE);
            USER_SCRIPT = SystemPropertiesSupport.singleton().getSavedProperty("user.script", "");
            USER_SCRIPT_DISPLAY = SystemPropertiesSupport.singleton().getSavedProperty("user.script.display", USER_SCRIPT);
            USER_SCRIPT_FORMAT = SystemPropertiesSupport.singleton().getSavedProperty("user.script.format", USER_SCRIPT);
            USER_COUNTRY = SystemPropertiesSupport.singleton().getSavedProperty("user.country", "");
            USER_COUNTRY_DISPLAY = SystemPropertiesSupport.singleton().getSavedProperty("user.country.display", USER_COUNTRY);
            USER_COUNTRY_FORMAT = SystemPropertiesSupport.singleton().getSavedProperty("user.country.format", USER_COUNTRY);
            USER_VARIANT = SystemPropertiesSupport.singleton().getSavedProperty("user.variant", "");
            USER_VARIANT_DISPLAY = SystemPropertiesSupport.singleton().getSavedProperty("user.variant.display", USER_VARIANT);
            USER_VARIANT_FORMAT = SystemPropertiesSupport.singleton().getSavedProperty("user.variant.format", USER_VARIANT);
            USER_EXTENSIONS = SystemPropertiesSupport.singleton().getSavedProperty("user.extensions", "");
            USER_EXTENSIONS_DISPLAY = SystemPropertiesSupport.singleton().getSavedProperty("user.extensions.display", USER_EXTENSIONS);
            USER_EXTENSIONS_FORMAT = SystemPropertiesSupport.singleton().getSavedProperty("user.extensions.format", USER_EXTENSIONS);
            USER_REGION = SystemPropertiesSupport.singleton().getSavedProperty("user.region", "");
        }
    }

    private static class StaticPropertyJdkSerialFilterFactoryAvailable
    extends StaticPropertyMethodAvailable {
        protected StaticPropertyJdkSerialFilterFactoryAvailable() {
            super("jdkSerialFilterFactory");
        }
    }

    private static abstract class StaticPropertyMethodAvailable
    implements BooleanSupplier {
        private final String methodName;

        protected StaticPropertyMethodAvailable(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public boolean getAsBoolean() {
            return ReflectionUtil.lookupMethod((boolean)true, StaticProperty.class, (String)this.methodName, (Class[])new Class[0]) != null;
        }
    }
}

