/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.IsolateListenerSupportFeature;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.NoSignalHandlerSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.jdk.SignalHandlerSupport;
import com.oracle.svm.core.jdk.StopDispatcherThread;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class SignalHandlerFeature
implements InternalFeature {
    SignalHandlerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(RuntimeSupportFeature.class, IsolateListenerSupportFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (ImageSingletons.contains(SignalHandlerSupport.class)) {
            SignalHandlerSupport support = SignalHandlerSupport.singleton();
            RuntimeSupport.getRuntimeSupport().addTearDownHook(new StopDispatcherThread());
            IsolateListenerSupport.singleton().register(support);
        } else {
            ImageSingletons.add(SignalHandlerSupport.class, (Object)new NoSignalHandlerSupport());
        }
    }
}

