/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;

public abstract class PlatformNativeLibrarySupport {
    public static final String[] defaultBuiltInLibraries = new String[]{"java", "nio", "net"};
    private static final String[] defaultBuiltInPkgNatives = new String[]{"com_sun_demo_jvmti_hprof", "com_sun_java_util_jar_pack", "com_sun_net_ssl", "com_sun_nio_file", "com_sun_security_cert_internal_x509", "java_io", "java_lang", "java_math", "java_net", "java_nio", "java_security", "java_text", "java_time", "java_util", "javax_net", "javax_script", "javax_security", "jdk_internal_io", "jdk_internal_jimage", "jdk_internal_misc", "jdk_internal_org", "jdk_internal_platform", "jdk_internal_util", "jdk_internal_vm", "jdk_net", "sun_invoke", "sun_launcher", "sun_misc", "sun_net", "sun_nio", "sun_reflect", "sun_text", "sun_util", "com_oracle_svm_core_jdk"};
    private static final String[] defaultBuiltInPkgNativesBlocklist;
    private List<String> builtInPkgNatives = new ArrayList<String>();
    private boolean builtInPkgNativesSealed;

    public static PlatformNativeLibrarySupport singleton() {
        return (PlatformNativeLibrarySupport)ImageSingletons.lookup(PlatformNativeLibrarySupport.class);
    }

    protected PlatformNativeLibrarySupport() {
        if (Platform.includedIn(InternalPlatform.PLATFORM_JNI.class)) {
            this.builtInPkgNatives.addAll(Arrays.asList(defaultBuiltInPkgNatives));
        }
    }

    public boolean isBuiltinLibrary(String name) {
        return false;
    }

    public void addBuiltinPkgNativePrefix(String name) {
        if (this.builtInPkgNativesSealed) {
            throw VMError.shouldNotReachHere("Cannot register any more packages as built-ins because information has already been used.");
        }
        this.builtInPkgNatives.add(name);
    }

    public boolean isBuiltinPkgNative(String name) {
        this.builtInPkgNativesSealed = true;
        String commonPrefix = "Java_";
        if (name.startsWith(commonPrefix)) {
            String strippedName = name.substring(commonPrefix.length());
            for (String str : defaultBuiltInPkgNativesBlocklist) {
                if (!strippedName.startsWith(str)) continue;
                return false;
            }
            for (String str : this.builtInPkgNatives) {
                if (!strippedName.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract NativeLibrary createLibrary(String var1, boolean var2);

    public abstract PointerBase findBuiltinSymbol(String var1);

    public abstract boolean initializeBuiltinLibraries();

    static {
        ArrayList blocklist = new ArrayList();
        Collections.addAll(blocklist, "sun_security_krb5_SCDynamicStoreConfig_getKerberosConfig", "sun_security_krb5_Config_getWindowsDirectory", "jdk_internal_org_jline_terminal_impl_jna_win_Kernel32Impl", "jdk_internal_misc_ScopedMemoryAccess_closeScope0", "jdk_internal_misc_ScopedMemoryAccess_registerNatives", "java_lang_invoke_VarHandle_weakCompareAndSetPlain", "java_lang_invoke_VarHandle_weakCompareAndSetRelease", "java_lang_invoke_VarHandle_getAndBitwiseAndAcquire", "java_lang_invoke_VarHandle_getVolatile", "java_lang_invoke_VarHandle_compareAndSet", "java_lang_invoke_VarHandle_compareAndExchangeRelease", "java_lang_invoke_VarHandle_getAndAddRelease", "java_lang_invoke_VarHandle_getAndBitwiseOr", "java_lang_invoke_VarHandle_getOpaque", "java_lang_invoke_VarHandle_compareAndExchangeAcquire", "java_lang_invoke_VarHandle_getAndBitwiseXorAcquire", "java_lang_invoke_VarHandle_get", "java_lang_invoke_VarHandle_setRelease", "java_lang_invoke_VarHandle_setVolatile", "java_lang_invoke_VarHandle_getAndBitwiseOrRelease", "java_lang_invoke_VarHandle_getAndBitwiseAnd", "java_lang_invoke_VarHandle_getAndBitwiseXorRelease", "java_lang_invoke_VarHandle_weakCompareAndSet", "java_lang_invoke_VarHandle_getAndSetRelease", "java_lang_invoke_VarHandle_weakCompareAndSetAcquire", "java_lang_invoke_VarHandle_setOpaque", "java_lang_invoke_VarHandle_getAndBitwiseAndRelease", "java_lang_invoke_VarHandle_getAndAdd", "java_lang_invoke_VarHandle_getAndBitwiseXor", "java_lang_invoke_VarHandle_getAndAddAcquire", "java_lang_invoke_VarHandle_getAndSet", "java_lang_invoke_VarHandle_getAndBitwiseOrAcquire", "java_lang_invoke_VarHandle_set", "java_lang_invoke_VarHandle_compareAndExchange", "java_lang_invoke_VarHandle_getAcquire", "java_lang_invoke_VarHandle_getAndSetAcquire");
        if (JavaVersionUtil.JAVA_SPEC > 21) {
            Collections.addAll(blocklist, "java_nio_MappedMemoryUtils_load0", "java_nio_MappedMemoryUtils_unload0", "java_nio_MappedMemoryUtils_isLoaded0", "java_nio_MappedMemoryUtils_force0");
        }
        defaultBuiltInPkgNativesBlocklist = blocklist.toArray(new String[0]);
    }

    public static interface NativeLibrary {
        public String getCanonicalIdentifier();

        public boolean isBuiltin();

        public boolean load();

        public boolean unload();

        public boolean isLoaded();

        public PointerBase findSymbol(String var1);
    }
}

