/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_ClassLoaderHelper;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public abstract class NativeLibraries {
    private String sysPath;
    private String[] usrPaths;

    protected static PointerBase findSymbol(Collection<PlatformNativeLibrarySupport.NativeLibrary> knownLibraries, String name) {
        for (PlatformNativeLibrarySupport.NativeLibrary lib : knownLibraries) {
            PointerBase entry = lib.findSymbol(name);
            if (!entry.isNonNull()) continue;
            return entry;
        }
        return WordFactory.nullPointer();
    }

    @NeverInline(value="Reads the return address.")
    public static String getImageDirectory() {
        String image = SubstrateOptions.SharedLibrary.getValue() == false ? ProcessProperties.getExecutableName() : ((ProcessPropertiesSupport)ImageSingletons.lookup(ProcessPropertiesSupport.class)).getObjectFile((PointerBase)KnownIntrinsics.readReturnAddress());
        return image != null ? new File(image).getParent() : null;
    }

    public void loadLibraryPlatformSpecific(String name) {
        if (this.addLibrary(name, false)) {
            return;
        }
        throw new UnsatisfiedLinkError("Can't load library: " + name);
    }

    public void loadLibraryPlatformSpecific(Path path) {
        try {
            this.loadLibraryPlatformSpecific(path.toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError("Can't load library: " + String.valueOf(path));
        }
    }

    public void loadLibraryAbsolute(File file) {
        if (this.loadLibrary0(file, false)) {
            return;
        }
        throw new UnsatisfiedLinkError("Can't load library: " + String.valueOf(file));
    }

    public void loadLibraryRelative(String name) {
        if (this.loadLibrary0(new File(name), true)) {
            return;
        }
        if (this.usrPaths == null) {
            this.sysPath = NativeLibraries.getImageDirectory();
            String[] tokens = SubstrateUtil.split(System.getProperty("java.library.path", ""), File.pathSeparator);
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].isEmpty()) continue;
                tokens[i] = ".";
            }
            this.usrPaths = tokens;
        }
        String libname = System.mapLibraryName(name);
        if (this.sysPath != null && this.loadLibrary0(new File(this.sysPath, libname), false)) {
            return;
        }
        for (String path : this.usrPaths) {
            File libpath = new File(path, libname);
            if (this.loadLibrary0(libpath, false)) {
                return;
            }
            File altpath = Target_jdk_internal_loader_ClassLoaderHelper.mapAlternativeName(libpath);
            if (altpath == null || !this.loadLibrary0(altpath, false)) continue;
            return;
        }
        throw new UnsatisfiedLinkError("Can't load library: " + name + " | java.library.path = " + Arrays.toString(this.usrPaths));
    }

    private boolean loadLibrary0(File file, boolean builtin) {
        try {
            String canonical = builtin ? file.getName() : file.getCanonicalPath();
            return this.addLibrary(canonical, builtin);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected abstract boolean addLibrary(String var1, boolean var2);

    public abstract PointerBase findSymbol(String var1);
}

