/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import jdk.internal.misc.Unsafe;

final class DirectMemoryAccessors {
    private static boolean initialized;
    private static long directMemory;

    DirectMemoryAccessors() {
    }

    static long getDirectMemory() {
        if (!initialized) {
            return DirectMemoryAccessors.tryInitialize();
        }
        return directMemory;
    }

    private static long tryInitialize() {
        long newDirectMemory = SubstrateOptions.MaxDirectMemorySize.getValue();
        if (newDirectMemory == 0L) {
            newDirectMemory = Runtime.getRuntime().maxMemory();
        }
        directMemory = newDirectMemory;
        Unsafe.getUnsafe().storeFence();
        initialized = true;
        return newDirectMemory;
    }
}

