/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.nodes.VerificationMarkerNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueDataNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.nodes.CPrologueData;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.LateLoweredNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;

public final class CFunctionSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo prologue;
    private final SnippetTemplate.SnippetInfo epilogue;
    private static final StackValueNode.StackSlotIdentity frameAnchorIdentity = new StackValueNode.StackSlotIdentity("CFunctionSnippets.frameAnchorIdentifier", true);

    @Snippet
    private static CPrologueData prologueSnippet(@Snippet.ConstantParameter int newThreadStatus) {
        JavaFrameAnchor anchor = (JavaFrameAnchor)LoweredStackValueNode.loweredStackValue(SizeOf.get(JavaFrameAnchor.class), FrameAccess.wordSize(), frameAnchorIdentity);
        JavaFrameAnchors.pushFrameAnchor(anchor);
        return CFunctionPrologueDataNode.cFunctionPrologueData(anchor, newThreadStatus);
    }

    @Snippet
    private static void epilogueSnippet(@Snippet.ConstantParameter int oldThreadStatus) {
        if (oldThreadStatus == 3) {
            Safepoint.transitionNativeToJava(true);
        } else if (oldThreadStatus == 4) {
            Safepoint.transitionVMToJava(true);
        } else {
            ReplacementsUtil.staticAssert((boolean)false, (String)"Unexpected thread status");
        }
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.ANY_LOCATION);
    }

    CFunctionSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.prologue = this.snippet(providers, CFunctionSnippets.class, "prologueSnippet", Snippet.SnippetType.TRANSPLANTED_SNIPPET, new LocationIdentity[0]);
        this.epilogue = this.snippet(providers, CFunctionSnippets.class, "epilogueSnippet", Snippet.SnippetType.TRANSPLANTED_SNIPPET, new LocationIdentity[0]);
        lowerings.put(CFunctionPrologueNode.class, new CFunctionPrologueLowering());
        lowerings.put(CFunctionEpilogueNode.class, new CFunctionEpilogueLowering());
    }

    private static void matchCallStructure(CFunctionPrologueNode prologueNode) {
        CFunctionPrologueNode cur = prologueNode;
        CFunctionPrologueNode singleInvoke = null;
        ArrayList<CFunctionPrologueNode> seenNodes = new ArrayList<CFunctionPrologueNode>();
        while (true) {
            seenNodes.add(cur);
            if (cur instanceof Invoke) {
                if (singleInvoke != null) {
                    throw VMError.shouldNotReachHere("Found more than one invoke: " + String.valueOf(seenNodes));
                }
                if (cur instanceof InvokeWithExceptionNode) {
                    throw VMError.shouldNotReachHere("Found InvokeWithExceptionNode: " + String.valueOf((Object)cur) + " in " + String.valueOf(seenNodes));
                }
                InvokeNode invoke = (InvokeNode)cur;
                VMError.guarantee(invoke.classInit() == null, "Re-using the classInit field to store the JavaFrameAnchor");
                invoke.setClassInit((ValueNode)prologueNode);
                singleInvoke = cur;
            }
            if (cur instanceof CFunctionEpilogueNode) {
                prologueNode.getMarker().setEpilogueMarker(((CFunctionEpilogueNode)((Object)cur)).getMarker());
                return;
            }
            if (!(cur instanceof FixedWithNextNode)) {
                throw VMError.shouldNotReachHere("Did not find a matching CFunctionEpilogueNode in same block: " + String.valueOf(seenNodes));
            }
            cur = ((FixedWithNextNode)cur).next();
        }
    }

    class CFunctionPrologueLowering
    implements NodeLoweringProvider<CFunctionPrologueNode> {
        CFunctionPrologueLowering() {
        }

        @Override
        public void lower(final CFunctionPrologueNode node, final LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            CFunctionSnippets.matchCallStructure(node);
            node.graph().addBeforeFixed((FixedNode)node, (FixedWithNextNode)node.graph().add((Node)new VerificationMarkerNode(node.getMarker())));
            ResolvedJavaMethod target = CFunctionSnippets.this.prologue.getMethod();
            Stamp returnStamp = StampFactory.forKind((JavaKind)target.getSignature().getReturnKind());
            StructuredGraph graph = node.graph();
            Supplier<SnippetTemplate> templateSupplier = new Supplier<SnippetTemplate>(this){
                final /* synthetic */ CFunctionPrologueLowering this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public SnippetTemplate get() {
                    int newThreadStatus = node.getNewThreadStatus();
                    assert (VMThreads.StatusSupport.isValidStatus(newThreadStatus));
                    SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.this$1.CFunctionSnippets.this.prologue, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("newThreadStatus", (Object)newThreadStatus);
                    SnippetTemplate template = this.this$1.CFunctionSnippets.this.template((CoreProviders)tool, (ValueNode)node, args);
                    return template;
                }
            };
            LateLoweredNode lateInvoke = (LateLoweredNode)graph.add((Node)new LateLoweredNode(target, returnStamp, new ValueNode[]{ConstantNode.forInt((int)node.getNewThreadStatus(), (StructuredGraph)graph)}, (Supplier)templateSupplier));
            lateInvoke.setStateBefore(node.stateBefore());
            lateInvoke.setStateAfter(node.stateAfter());
            node.graph().replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)lateInvoke);
            lateInvoke.setAfterInlineeBasicBlockAction(x -> x.setCanUseBlockAsSpillTarget(false));
        }
    }

    class CFunctionEpilogueLowering
    implements NodeLoweringProvider<CFunctionEpilogueNode> {
        CFunctionEpilogueLowering() {
        }

        @Override
        public void lower(final CFunctionEpilogueNode node, final LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            node.graph().addAfterFixed((FixedWithNextNode)node, (FixedNode)node.graph().add((Node)new VerificationMarkerNode(node.getMarker())));
            ResolvedJavaMethod target = CFunctionSnippets.this.prologue.getMethod();
            Stamp returnStamp = StampFactory.forKind((JavaKind)target.getSignature().getReturnKind());
            StructuredGraph graph = node.graph();
            Supplier<SnippetTemplate> templateSupplier = new Supplier<SnippetTemplate>(this){
                final /* synthetic */ CFunctionEpilogueLowering this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public SnippetTemplate get() {
                    int oldThreadStatus = node.getOldThreadStatus();
                    assert (VMThreads.StatusSupport.isValidStatus(oldThreadStatus));
                    SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.this$1.CFunctionSnippets.this.epilogue, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("oldThreadStatus", (Object)oldThreadStatus);
                    SnippetTemplate template = this.this$1.CFunctionSnippets.this.template((CoreProviders)tool, (ValueNode)node, args);
                    return template;
                }
            };
            LateLoweredNode lateInvoke = (LateLoweredNode)graph.add((Node)new LateLoweredNode(target, returnStamp, new ValueNode[]{ConstantNode.forInt((int)node.getOldThreadStatus(), (StructuredGraph)graph)}, (Supplier)templateSupplier));
            lateInvoke.setStateBefore(node.stateBefore());
            lateInvoke.setStateAfter(node.stateAfter());
            node.graph().replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)lateInvoke);
            lateInvoke.setAfterInlineeBasicBlockAction(x -> x.setCanUseBlockAsSpillTarget(false));
        }
    }
}

