/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateMethodPointerStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.nodes.spi.StampProvider;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SubstrateStampProvider
implements StampProvider {
    private final AbstractPointerStamp hubStamp;
    private final AbstractPointerStamp methodStamp;
    private final AbstractPointerStamp methodAlwaysNullStamp;

    public SubstrateStampProvider(MetaAccessProvider metaAccess) {
        this.hubStamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)metaAccess.lookupJavaType(DynamicHub.class)));
        this.methodStamp = SubstrateMethodPointerStamp.methodNonNull();
        this.methodAlwaysNullStamp = SubstrateMethodPointerStamp.methodAlwaysNull();
    }

    public AbstractPointerStamp createHubStamp(ObjectStamp object) {
        return this.hubStamp;
    }

    public AbstractPointerStamp createMethodStamp() {
        return this.methodStamp;
    }

    public AbstractPointerStamp createMethodAlwaysNullStamp() {
        return this.methodAlwaysNullStamp;
    }

    public Constant methodPointerAlwaysNullConstant() {
        return SubstrateMethodPointerConstant.ALWAYS_NULL;
    }
}

