/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class SharedCodeCacheProvider
implements CodeCacheProvider {
    protected final TargetDescription target;
    protected final RegisterConfig registerConfig;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SharedCodeCacheProvider(TargetDescription target, RegisterConfig registerConfig) {
        this.target = target;
        this.registerConfig = registerConfig;
    }

    public void invalidateInstalledCode(InstalledCode installedCode) {
        throw VMError.intentionallyUnimplemented();
    }

    public long getMaxCallTargetOffset(long address) {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean shouldDebugNonSafepoints() {
        return false;
    }

    public SpeculationLog createSpeculationLog() {
        throw VMError.intentionallyUnimplemented();
    }

    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    public int getMinimumOutgoingSize() {
        return 0;
    }

    public TargetDescription getTarget() {
        return this.target;
    }
}

