/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.compacting.ObjectFixupVisitor;
import com.oracle.svm.core.genscavenge.remset.BrickTable;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ObjectMoveInfo {
    public static final int MAX_CHUNK_SIZE = 524288;

    static void setNewAddress(Pointer objSeqStart, Pointer newAddress) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            long offset = newAddress.subtract((UnsignedWord)objSeqStart).rawValue();
            objSeqStart.writeInt(-8, (int)(offset /= (long)ConfigurationValues.getObjectLayout().getAlignment()));
        } else {
            objSeqStart.writeWord(-16, (WordBase)newAddress);
        }
        assert (ObjectMoveInfo.getNewAddress(objSeqStart).equal((UnsignedWord)newAddress));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer getNewAddress(Pointer objSeqStart) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            long offset = objSeqStart.readInt(-8);
            return objSeqStart.add((UnsignedWord)WordFactory.signed((long)(offset *= (long)ConfigurationValues.getObjectLayout().getAlignment())));
        }
        return (Pointer)objSeqStart.readWord(-16);
    }

    static void setObjectSeqSize(Pointer objSeqStart, UnsignedWord nbytes) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            UnsignedWord value = nbytes.unsignedDivide(ConfigurationValues.getObjectLayout().getAlignment());
            objSeqStart.writeShort(-4, (short)value.rawValue());
        } else {
            objSeqStart.writeInt(-8, (int)nbytes.rawValue());
        }
        assert (ObjectMoveInfo.getObjectSeqSize(objSeqStart).equal(nbytes));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getObjectSeqSize(Pointer objSeqStart) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            UnsignedWord value = WordFactory.unsigned((int)(objSeqStart.readShort(-4) & 0xFFFF));
            return value.multiply(ConfigurationValues.getObjectLayout().getAlignment());
        }
        return WordFactory.unsigned((int)objSeqStart.readInt(-8));
    }

    static void setNextObjectSeqOffset(Pointer objSeqStart, UnsignedWord offset) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            UnsignedWord value = offset.unsignedDivide(ConfigurationValues.getObjectLayout().getAlignment());
            objSeqStart.writeShort(-2, (short)value.rawValue());
        } else {
            objSeqStart.writeInt(-4, (int)offset.rawValue());
        }
        assert (ObjectMoveInfo.getNextObjectSeqOffset(objSeqStart).equal(offset));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getNextObjectSeqOffset(Pointer objSeqStart) {
        if (ObjectMoveInfo.useCompressedLayout()) {
            UnsignedWord value = WordFactory.unsigned((int)(objSeqStart.readShort(-2) & 0xFFFF));
            return value.multiply(ConfigurationValues.getObjectLayout().getAlignment());
        }
        return WordFactory.unsigned((int)objSeqStart.readInt(-4));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer getNextObjectSeqAddress(Pointer objSeqStart) {
        UnsignedWord offset = ObjectMoveInfo.getNextObjectSeqOffset(objSeqStart);
        if (offset.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        return objSeqStart.add(offset);
    }

    @Fold
    static boolean useCompressedLayout() {
        return ConfigurationValues.getObjectLayout().getReferenceSize() == 4;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkObjects(AlignedHeapChunk.AlignedHeader chunkHeader, ObjectFixupVisitor visitor) {
        Pointer nextObjSeq;
        Pointer p = AlignedHeapChunk.getObjectsStart(chunkHeader);
        do {
            nextObjSeq = ObjectMoveInfo.getNextObjectSeqAddress(p);
            Pointer objSeqEnd = p.add(ObjectMoveInfo.getObjectSeqSize(p));
            assert (objSeqEnd.belowOrEqual((UnsignedWord)HeapChunk.getTopPointer(chunkHeader)));
            while (p.notEqual((UnsignedWord)objSeqEnd)) {
                assert (p.belowThan((UnsignedWord)objSeqEnd));
                Object obj = p.toObject();
                UnsignedWord objSize = LayoutEncoding.getSizeFromObjectInlineInGC(obj);
                if (!visitor.visitObjectInline(obj)) {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
                p = p.add(objSize);
            }
        } while ((p = nextObjSeq).isNonNull());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer getNewObjectAddress(Pointer objPointer) {
        assert (ObjectHeaderImpl.isAlignedObject(objPointer.toObject()));
        AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(objPointer);
        if (objPointer.aboveOrEqual((UnsignedWord)HeapChunk.getTopPointer(chunk))) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer objSeq = BrickTable.getEntry(chunk, BrickTable.getIndex(chunk, objPointer));
        if (objSeq.aboveThan((UnsignedWord)objPointer)) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer nextObjSeq = ObjectMoveInfo.getNextObjectSeqAddress(objSeq);
        while (nextObjSeq.isNonNull() && nextObjSeq.belowOrEqual((UnsignedWord)objPointer)) {
            objSeq = nextObjSeq;
            nextObjSeq = ObjectMoveInfo.getNextObjectSeqAddress(objSeq);
        }
        if (objPointer.aboveOrEqual((UnsignedWord)objSeq.add(ObjectMoveInfo.getObjectSeqSize(objSeq)))) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer newObjSeqAddress = ObjectMoveInfo.getNewAddress(objSeq);
        Pointer objOffset = objPointer.subtract((UnsignedWord)objSeq);
        return newObjSeqAddress.add((UnsignedWord)objOffset);
    }

    public static int getSize() {
        return ObjectMoveInfo.useCompressedLayout() ? 8 : 16;
    }

    @AlwaysInline(value="GC performance: enables non-virtual visitor call")
    public static void visit(AlignedHeapChunk.AlignedHeader chunk, Visitor visitor) {
        Pointer p = AlignedHeapChunk.getObjectsStart(chunk);
        UnsignedWord size = ObjectMoveInfo.getObjectSeqSize(p);
        Pointer newAddress = ObjectMoveInfo.getNewAddress(p);
        Pointer next = ObjectMoveInfo.getNextObjectSeqAddress(p);
        do {
            Pointer nextNext;
            UnsignedWord nextSize = next.isNonNull() ? ObjectMoveInfo.getObjectSeqSize(next) : (UnsignedWord)WordFactory.zero();
            Pointer nextNewAddress = next.isNonNull() ? ObjectMoveInfo.getNewAddress(next) : (Pointer)WordFactory.nullPointer();
            Pointer pointer = nextNext = next.isNonNull() ? ObjectMoveInfo.getNextObjectSeqAddress(next) : (Pointer)WordFactory.nullPointer();
            if (!visitor.visit(p, size, newAddress, next)) {
                return;
            }
            p = next;
            size = nextSize;
            newAddress = nextNewAddress;
            next = nextNext;
        } while (p.isNonNull());
    }

    private ObjectMoveInfo() {
    }

    public static interface Visitor {
        public boolean visit(Pointer var1, UnsignedWord var2, Pointer var3, Pointer var4);
    }
}

