/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;

public class VMInspectionOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AllowVMInspection": {
                return OptionDescriptor.create((String)"AllowVMInspection", (OptionType)OptionType.User, Boolean.class, (String)"Enables features that allow the VM to be inspected during run time.", VMInspectionOptions.DeprecatedOptions.class, (String)"AllowVMInspection", VMInspectionOptions.DeprecatedOptions.AllowVMInspection, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Please use '--enable-monitoring'");
            }
            case "DumpRuntimeCompilationOnSignal": {
                return OptionDescriptor.create((String)"DumpRuntimeCompilationOnSignal", (OptionType)OptionType.User, Boolean.class, (String)"Dumps all runtime compiled methods on SIGUSR2.", VMInspectionOptions.class, (String)"DumpRuntimeCompilationOnSignal", VMInspectionOptions.DumpRuntimeCompilationOnSignal, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpThreadStacksOnSignal": {
                return OptionDescriptor.create((String)"DumpThreadStacksOnSignal", (OptionType)OptionType.User, Boolean.class, (String)"Dumps all thread stacktraces on SIGQUIT/SIGBREAK.", VMInspectionOptions.DeprecatedOptions.class, (String)"DumpThreadStacksOnSignal", VMInspectionOptions.DeprecatedOptions.DumpThreadStacksOnSignal, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Please use '--enable-monitoring=threaddump'");
            }
            case "EnableMonitoringFeatures": {
                return OptionDescriptor.create((String)"EnableMonitoringFeatures", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Enable monitoring features that allow the VM to be inspected at run time. Comma-separated list can contain 'heapdump', 'jfr', 'jvmstat', 'jmxserver' (experimental), 'jmxclient' (experimental), 'threaddump', 'nmt' (experimental), 'jcmd' (experimental), or 'all' (deprecated behavior: defaults to 'all' if no argument is provided). For example: '--enable-monitoring=heapdump,jfr'.", VMInspectionOptions.class, (String)"EnableMonitoringFeatures", VMInspectionOptions.EnableMonitoringFeatures, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintNMTStatistics": {
                return OptionDescriptor.create((String)"PrintNMTStatistics", (OptionType)OptionType.User, Boolean.class, (String)"Print native memory tracking statistics on shutdown if native memory tracking is enabled.", VMInspectionOptions.class, (String)"PrintNMTStatistics", VMInspectionOptions.PrintNMTStatistics, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 5;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return VMInspectionOptions_OptionDescriptors.this.get("AllowVMInspection");
                    }
                    case 1: {
                        return VMInspectionOptions_OptionDescriptors.this.get("DumpRuntimeCompilationOnSignal");
                    }
                    case 2: {
                        return VMInspectionOptions_OptionDescriptors.this.get("DumpThreadStacksOnSignal");
                    }
                    case 3: {
                        return VMInspectionOptions_OptionDescriptors.this.get("EnableMonitoringFeatures");
                    }
                    case 4: {
                        return VMInspectionOptions_OptionDescriptors.this.get("PrintNMTStatistics");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

