/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.reachability.MethodSummary;
import com.oracle.graal.reachability.MethodSummaryProvider;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisField;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.graal.reachability.ReachabilityInvokeInfo;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Optional;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.AnnotationAccess;

public class SimpleInMemoryMethodSummaryProvider
implements MethodSummaryProvider {
    @Override
    public MethodSummary getSummary(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        StructuredGraph decoded = ReachabilityAnalysisMethod.getDecodedGraph(bb, method);
        return SimpleInMemoryMethodSummaryProvider.createSummaryFromGraph(bb, decoded, method);
    }

    @Override
    public MethodSummary getSummary(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        return SimpleInMemoryMethodSummaryProvider.createSummaryFromGraph(bb, graph, null);
    }

    private static MethodSummary createSummaryFromGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph, ReachabilityAnalysisMethod method) {
        EconomicSet accessedTypes = EconomicSet.create();
        EconomicSet instantiatedTypes = EconomicSet.create();
        EconomicSet readFields = EconomicSet.create();
        EconomicSet writtenFields = EconomicSet.create();
        EconomicSet virtualInvokedMethods = EconomicSet.create();
        EconomicSet specialInvokedMethods = EconomicSet.create();
        EconomicSet implementationInvokedMethods = EconomicSet.create();
        EconomicSet embeddedConstants = EconomicSet.create();
        EconomicSet foreignCallTargets = EconomicSet.create();
        if (method != null) {
            int offset;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            int parameterCount = method.getSignature().getParameterCount(!isStatic);
            for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
                accessedTypes.add((Object)((AnalysisType)method.getSignature().getParameterType(i - offset)));
            }
            accessedTypes.add((Object)((AnalysisType)method.getSignature().getReturnType()));
        }
        for (Node n : graph.getNodes()) {
            MultiMethod.MultiMethodKey key;
            if (n instanceof NewInstanceNode) {
                NewInstanceNode node = (NewInstanceNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.instanceClass()));
                continue;
            }
            if (n instanceof NewArrayNode) {
                NewArrayNode node = (NewArrayNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.elementType()).getArrayClass());
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                ResolvedJavaType type = node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    instantiatedTypes.add((Object)((ReachabilityAnalysisType)type));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof VirtualInstanceNode) {
                VirtualInstanceNode node = (VirtualInstanceNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.type()));
                continue;
            }
            if (n instanceof VirtualArrayNode) {
                VirtualArrayNode node = (VirtualArrayNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.componentType()).getArrayClass());
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode node = (ConstantNode)n;
                if (!(node.getValue() instanceof JavaConstant)) continue;
                embeddedConstants.add((Object)((JavaConstant)node.getValue()));
                continue;
            }
            if (n instanceof FieldOffsetProvider) {
                FieldOffsetProvider node = (FieldOffsetProvider)n;
                ((AnalysisField)node.getField()).registerAsUnsafeAccessed((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node.asNode()));
                continue;
            }
            if (n instanceof InstanceOfNode) {
                InstanceOfNode node = (InstanceOfNode)n;
                accessedTypes.add((Object)((ReachabilityAnalysisType)node.type().getType()));
                continue;
            }
            if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                readFields.add((Object)((ReachabilityAnalysisField)node.field()));
                continue;
            }
            if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                writtenFields.add((Object)((ReachabilityAnalysisField)node.field()));
                continue;
            }
            if (n instanceof Invoke) {
                Invoke node = (Invoke)n;
                CallTargetNode.InvokeKind kind = node.getInvokeKind();
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                if (targetMethod == null || AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)targetMethod), Node.NodeIntrinsic.class)) continue;
                if (method != null) {
                    method.addInvoke(new ReachabilityInvokeInfo(targetMethod, AbstractAnalysisEngine.sourcePosition((ValueNode)node.asNode()), kind.isDirect()));
                }
                if (kind == CallTargetNode.InvokeKind.Static) {
                    implementationInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                if (kind == CallTargetNode.InvokeKind.Special) {
                    specialInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                virtualInvokedMethods.add((Object)targetMethod);
                continue;
            }
            if (n instanceof FrameState) {
                FrameState node = (FrameState)n;
                ResolvedJavaMethod frameMethod = node.getMethod();
                if (frameMethod == null) continue;
                ReachabilityAnalysisMethod analysisMethod = (ReachabilityAnalysisMethod)frameMethod;
                accessedTypes.add((Object)analysisMethod.getDeclaringClass());
                continue;
            }
            if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                CallTargetNode.InvokeKind kind = node.getInvokeKind();
                if (kind == CallTargetNode.InvokeKind.Static) {
                    implementationInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                if (kind == CallTargetNode.InvokeKind.Special) {
                    specialInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                virtualInvokedMethods.add((Object)targetMethod);
                continue;
            }
            if (n instanceof ForeignCall) {
                MultiMethod.MultiMethodKey key2 = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
                ForeignCallsProvider foreignCallsProvider = bb.getProviders(key2).getForeignCalls();
                SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, ((ForeignCall)n).getDescriptor(), foreignCallsProvider);
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                ForeignCallSignature signature = ((UnaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
                key = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
                ForeignCallsProvider foreignCallsProvider = bb.getProviders(key).getForeignCalls();
                SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, foreignCallsProvider.getDescriptor(signature), foreignCallsProvider);
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            ForeignCallSignature signature = ((BinaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
            key = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
            ForeignCallsProvider foreignCallsProvider = bb.getProviders(key).getForeignCalls();
            SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, foreignCallsProvider.getDescriptor(signature), foreignCallsProvider);
        }
        return new MethodSummary((EconomicSet<AnalysisMethod>)virtualInvokedMethods, (EconomicSet<AnalysisMethod>)specialInvokedMethods, (EconomicSet<AnalysisMethod>)implementationInvokedMethods, (EconomicSet<AnalysisType>)accessedTypes, (EconomicSet<AnalysisType>)instantiatedTypes, (EconomicSet<AnalysisField>)readFields, (EconomicSet<AnalysisField>)writtenFields, (EconomicSet<JavaConstant>)embeddedConstants, (EconomicSet<AnalysisMethod>)foreignCallTargets);
    }

    private static void handleForeignCall(ReachabilityAnalysisEngine bb, EconomicSet<AnalysisMethod> foreignCallTargets, ForeignCallDescriptor descriptor, ForeignCallsProvider foreignCallsProvider) {
        Optional targetMethod = bb.getHostVM().handleForeignCall(descriptor, foreignCallsProvider);
        targetMethod.ifPresent(arg_0 -> foreignCallTargets.add(arg_0));
    }
}

