/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import java.util.Arrays;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ReachableThreadGroup {
    int ngroups;
    ThreadGroup[] groups;

    ReachableThreadGroup() {
    }

    synchronized void add(ThreadGroup g) {
        if (this.groups == null) {
            this.groups = new ThreadGroup[4];
        } else if (this.ngroups == this.groups.length) {
            this.groups = Arrays.copyOf(this.groups, this.ngroups * 2);
        }
        this.groups[this.ngroups] = g;
        ++this.ngroups;
    }
}

