/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.VarHandleSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jdk.VarHandleInfo;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class VarHandleFeature
implements InternalFeature {
    private Map<Class<?>, VarHandleInfo> infos;
    private AnalysisUniverse aUniverse;
    private HostedUniverse hUniverse;
    private static final Field varHandleVFormField = ReflectionUtil.lookupField(VarHandle.class, (String)"vform");
    private static final Method varFormInitMethod = ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.VarForm"), (String)"getMethodType_V", (Class[])new Class[]{Integer.TYPE});
    private static final Method varHandleGetMethodHandleMethod = ReflectionUtil.lookupMethod(VarHandle.class, (String)"getMethodHandle", (Class[])new Class[]{Integer.TYPE});

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.aUniverse = access.getUniverse();
        this.infos = VarHandleFeature.buildInfos();
        ImageSingletons.add(VarHandleSupport.class, (Object)new VarHandleSupportImpl());
        access.registerObjectReplacer(VarHandleFeature::eagerlyInitializeVarHandle);
        access.registerObjectReachableCallback(VarHandle.class, (a1, obj, reason) -> this.registerReachableHandle(obj, reason));
        access.registerObjectReachableCallback(access.findClassByName("java.lang.invoke.DirectMethodHandle"), (a1, obj, reason) -> this.registerReachableHandle(obj, reason));
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        this.hUniverse = access.getUniverse();
    }

    private static Object eagerlyInitializeVarHandle(Object obj) {
        if (obj instanceof VarHandle) {
            VarHandle varHandle = (VarHandle)obj;
            VarHandleFeature.eagerlyInitializeVarHandle(varHandle);
        }
        return obj;
    }

    public static void eagerlyInitializeVarHandle(VarHandle varHandle) {
        try {
            Object varForm = varHandleVFormField.get(varHandle);
            varFormInitMethod.invoke(varForm, 0);
            for (VarHandle.AccessMode accessMode : VarHandle.AccessMode.values()) {
                boolean isAccessModeSupported = varHandle.isAccessModeSupported(accessMode);
                varHandle.accessModeType(accessMode);
                if (!isAccessModeSupported) continue;
                varHandleGetMethodHandleMethod.invoke((Object)varHandle, accessMode.ordinal());
            }
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static Map<Class<?>, VarHandleInfo> buildInfos() {
        HashMap infos = new HashMap();
        for (String typeName : new String[]{"Booleans", "Bytes", "Chars", "Doubles", "Floats", "Ints", "Longs", "Shorts", "References"}) {
            VarHandleFeature.buildInfo(infos, false, "receiverType", ReflectionUtil.lookupClass((boolean)false, (String)("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadOnly")), ReflectionUtil.lookupClass((boolean)false, (String)("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadWrite")));
            VarHandleFeature.buildInfo(infos, true, "base", ReflectionUtil.lookupClass((boolean)false, (String)("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadOnly")), ReflectionUtil.lookupClass((boolean)false, (String)("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadWrite")));
        }
        Class staticAccessorClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$StaticAccessor");
        infos.put(staticAccessorClass, new VarHandleInfo(true, VarHandleFeature.createOffsetFieldGetter(staticAccessorClass, "staticOffset"), VarHandleFeature.createTypeFieldGetter(staticAccessorClass, "staticBase")));
        Class accessorClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$Accessor");
        Function<Object, Class<?>> accessorTypeGetter = obj -> ((MethodHandle)obj).type().parameterType(0);
        infos.put(accessorClass, new VarHandleInfo(false, VarHandleFeature.createOffsetFieldGetter(accessorClass, "fieldOffset"), accessorTypeGetter));
        return infos;
    }

    private static void buildInfo(Map<Class<?>, VarHandleInfo> infos, boolean isStatic, String typeFieldName, Class<?> readOnlyClass, Class<?> readWriteClass) {
        ToLongFunction<Object> offsetGetter = VarHandleFeature.createOffsetFieldGetter(readOnlyClass, "fieldOffset");
        Function<Object, Class<?>> typeGetter = VarHandleFeature.createTypeFieldGetter(readOnlyClass, typeFieldName);
        VarHandleInfo readOnlyInfo = new VarHandleInfo(isStatic, offsetGetter, typeGetter);
        infos.put(readOnlyClass, readOnlyInfo);
        infos.put(readWriteClass, readOnlyInfo);
    }

    private static ToLongFunction<Object> createOffsetFieldGetter(Class<?> clazz, String offsetFieldName) {
        Field offsetField = ReflectionUtil.lookupField(clazz, (String)offsetFieldName);
        return obj -> {
            try {
                return offsetField.getLong(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        };
    }

    private static Function<Object, Class<?>> createTypeFieldGetter(Class<?> clazz, String typeFieldName) {
        Field typeField = ReflectionUtil.lookupField(clazz, (String)typeFieldName);
        return obj -> {
            try {
                return (Class)typeField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        };
    }

    private Object registerReachableHandle(Object obj, ObjectScanner.ScanReason reason) {
        AnalysisField field;
        VarHandleInfo info = this.infos.get(obj.getClass());
        if (info != null && !(field = this.findVarHandleAnalysisField(obj)).isUnsafeAccessed()) {
            VMError.guarantee(this.hUniverse == null, "New VarHandle %s found after static analysis for field %s", obj, field);
            field.registerAsUnsafeAccessed((Object)reason);
        }
        return obj;
    }

    ResolvedJavaField findVarHandleOriginalField(Object varHandle) {
        VarHandleInfo info = this.infos.get(varHandle.getClass());
        ResolvedJavaType originalType = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(info.typeGetter().apply(varHandle));
        long originalFieldOffset = info.offsetGetter().applyAsLong(varHandle);
        for (ResolvedJavaField field : info.isStatic() ? originalType.getStaticFields() : originalType.getInstanceFields(true)) {
            long fieldOffset = field.getOffset();
            if (fieldOffset != originalFieldOffset) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Could not find field referenced in VarHandle: " + String.valueOf(originalType) + ", offset = " + originalFieldOffset + ", isStatic = " + info.isStatic());
    }

    AnalysisField findVarHandleAnalysisField(Object varHandle) {
        return this.aUniverse.lookup((JavaField)this.findVarHandleOriginalField(varHandle));
    }

    HostedField findVarHandleHostedField(Object varHandle) {
        return this.hUniverse.lookup((JavaField)this.findVarHandleAnalysisField(varHandle));
    }

    class VarHandleSupportImpl
    extends VarHandleSupport {
        VarHandleSupportImpl() {
        }

        @Override
        protected ResolvedJavaField findVarHandleField(Object varHandle) {
            return VarHandleFeature.this.hUniverse != null ? VarHandleFeature.this.findVarHandleHostedField(varHandle) : VarHandleFeature.this.findVarHandleAnalysisField(varHandle);
        }
    }
}

