/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.code.IncompatibleClassChangeFallbackMethod;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SVMImageLayerSnapshotUtil
extends ImageLayerSnapshotUtil {
    private static final String GENERATED_SERIALIZATION = "jdk.internal.reflect.GeneratedSerializationConstructorAccessor";
    public static final Field companion = ReflectionUtil.lookupField(DynamicHub.class, (String)"companion");
    public static final Field classInitializationInfo = ReflectionUtil.lookupField(DynamicHub.class, (String)"classInitializationInfo");
    private static final Field name = ReflectionUtil.lookupField(DynamicHub.class, (String)"name");
    private static final Field superHub = ReflectionUtil.lookupField(DynamicHub.class, (String)"superHub");
    private static final Field componentType = ReflectionUtil.lookupField(DynamicHub.class, (String)"componentType");
    public static final Field arrayHub = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");
    public static final Field interfacesEncoding = ReflectionUtil.lookupField(DynamicHub.class, (String)"interfacesEncoding");
    public static final Field enumConstantsReference = ReflectionUtil.lookupField(DynamicHub.class, (String)"enumConstantsReference");
    protected static final Set<Field> dynamicHubRelinkedFields = Set.of(companion, classInitializationInfo, name, superHub, componentType, arrayHub);
    protected final Map<AnalysisType, Set<Integer>> fieldsToRelink = new HashMap<AnalysisType, Set<Integer>>();

    public String getTypeIdentifier(AnalysisType type) {
        if (type.toJavaName(true).contains(GENERATED_SERIALIZATION)) {
            SVMImageLayerSnapshotUtil.getGeneratedSerializationName(type);
        }
        if (ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type)) {
            return type.toJavaName(true);
        }
        return super.getTypeIdentifier(type);
    }

    private static String generatedSerializationClassName(SerializationSupport.SerializationLookupKey serializationLookupKey) {
        return "jdk.internal.reflect.GeneratedSerializationConstructorAccessor:" + String.valueOf(serializationLookupKey.getDeclaringClass()) + "," + String.valueOf(serializationLookupKey.getTargetConstructorClass());
    }

    public String getMethodIdentifier(AnalysisMethod method) {
        Executable originalMethod;
        AnalysisType declaringClass = method.getDeclaringClass();
        String moduleName = declaringClass.getJavaClass().getModule().getName();
        if (declaringClass.toJavaName(true).contains(GENERATED_SERIALIZATION)) {
            return SVMImageLayerSnapshotUtil.getGeneratedSerializationName(declaringClass) + ":" + method.getName();
        }
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            ResolvedJavaMethod targetConstructor = factoryMethod.getTargetConstructor();
            return SVMImageLayerSnapshotUtil.addModuleName((String)(targetConstructor.getDeclaringClass().toJavaName(true) + SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method)), (String)moduleName);
        }
        if (method.wrapped instanceof IncompatibleClassChangeFallbackMethod && (originalMethod = method.getJavaMethod()) != null) {
            return SVMImageLayerSnapshotUtil.addModuleName((String)(method.getQualifiedName() + " " + method.getJavaMethod().toString()), (String)moduleName);
        }
        if (!(method.wrapped instanceof HotSpotResolvedJavaMethod)) {
            return SVMImageLayerSnapshotUtil.addModuleName((String)SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method), (String)moduleName);
        }
        if (LambdaUtils.isLambdaType((ResolvedJavaType)declaringClass) || InjectedInvokerRenamingSubstitutionProcessor.isInjectedInvokerType((ResolvedJavaType)declaringClass) || MethodHandleInvokerRenamingSubstitutionProcessor.isMethodHandleType((ResolvedJavaType)declaringClass) || ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)declaringClass)) {
            return SVMImageLayerSnapshotUtil.getQualifiedName((AnalysisMethod)method);
        }
        return super.getMethodIdentifier(method);
    }

    private static String getGeneratedSerializationName(AnalysisType type) {
        Class constructorAccessor = type.getJavaClass();
        SerializationSupport serializationRegistry = SerializationSupport.singleton();
        SerializationSupport.SerializationLookupKey serializationLookupKey = serializationRegistry.getKeyFromConstructorAccessorClass(constructorAccessor);
        return SVMImageLayerSnapshotUtil.generatedSerializationClassName(serializationLookupKey);
    }

    public Set<Integer> getRelinkedFields(AnalysisType type, AnalysisMetaAccess metaAccess) {
        Set result = this.fieldsToRelink.computeIfAbsent(type, key -> {
            Class clazz = type.getJavaClass();
            if (clazz == Class.class) {
                type.getInstanceFields(true);
                return dynamicHubRelinkedFields.stream().map(arg_0 -> ((AnalysisMetaAccess)metaAccess).lookupJavaField(arg_0)).map(AnalysisField::getPosition).collect(Collectors.toSet());
            }
            return null;
        });
        if (result == null) {
            return Set.of();
        }
        return result;
    }
}

