/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionRegistryAdapter
extends RegistryAdapter {
    private final RuntimeReflectionSupport reflectionSupport;
    private final ProxyRegistry proxyRegistry;

    ReflectionRegistryAdapter(RuntimeReflectionSupport reflectionSupport, ProxyRegistry proxyRegistry, ImageClassLoader classLoader) {
        super((ReflectionRegistry)reflectionSupport, classLoader);
        this.reflectionSupport = reflectionSupport;
        this.proxyRegistry = proxyRegistry;
    }

    @Override
    public void registerType(ConfigurationCondition condition, Class<?> type) {
        super.registerType(condition, type);
        if (Proxy.isProxyClass(type)) {
            this.proxyRegistry.accept(condition, Arrays.stream(type.getInterfaces()).map(Class::getTypeName).toList());
        }
    }

    @Override
    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        TypeResult<Class<?>> result = super.resolveType(condition, typeDescriptor, allowPrimitives);
        if (!result.isPresent() && typeDescriptor instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedDescriptor = (NamedConfigurationTypeDescriptor)typeDescriptor;
            Throwable classLookupException = result.getException();
            if (classLookupException instanceof LinkageError) {
                this.reflectionSupport.registerClassLookupException(condition, namedDescriptor.name(), classLookupException);
            }
        }
        return result;
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllClassesQuery(condition, type);
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredClassesQuery(condition, type);
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllRecordComponentsQuery(condition, type);
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllPermittedSubclassesQuery(condition, type);
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllNestMembersQuery(condition, type);
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllSignersQuery(condition, type);
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        ((ReflectionDataBuilder)this.reflectionSupport).registerAllFieldsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        ((ReflectionDataBuilder)this.reflectionSupport).registerAllDeclaredFieldsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllMethodsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredMethodsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllConstructorsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredConstructorsQuery(condition, queriedOnly, type);
    }
}

