/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ObjectTreePrinter;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaMethod;

public final class ReachabilityTracePrinter {
    public static final String PATH_MESSAGE_PREFIX = "See the generated report for a complete reachability trace: ";

    public static void report(String imageName, OptionValues options, String reportsPath, BigBang bb) {
        StringWriter stringWriter;
        int count;
        List<String> fieldPatterns;
        StringWriter stringWriter2;
        int count2;
        List<String> methodPatterns;
        StringWriter stringWriter3;
        int count3;
        String baseImageName = ReportUtils.extractImageName((String)imageName);
        StringBuilder consoleMessageBuilder = new StringBuilder();
        List<String> typePatterns = ((LocatableMultiOptionValue.Strings)Options.AbortOnTypeReachable.getValue(options)).values();
        if (!typePatterns.isEmpty() && (count3 = ReachabilityTracePrinter.printTraceForTypesImpl(typePatterns, bb, new PrintWriter(stringWriter3 = new StringWriter()))) > 0) {
            String trace = stringWriter3.toString();
            Path path = ReportUtils.report((String)"trace for types", (String)reportsPath, (String)("trace_types_" + baseImageName), (String)"txt", writer -> writer.print(trace));
            String abortOnTypeReachableOption = SubstrateOptionsParser.commandArgument(Options.AbortOnTypeReachable, String.join((CharSequence)",", typePatterns));
            String message = "Image building is interrupted as the types specified via " + abortOnTypeReachableOption + " are reachable. See the generated report for a complete reachability trace: " + String.valueOf(path);
            consoleMessageBuilder.append(message);
        }
        if (!(methodPatterns = ((LocatableMultiOptionValue.Strings)Options.AbortOnMethodReachable.getValue(options)).values()).isEmpty() && (count2 = ReachabilityTracePrinter.printTraceForMethodsImpl(methodPatterns, bb, new PrintWriter(stringWriter2 = new StringWriter()))) > 0) {
            String trace = stringWriter2.toString();
            Path path = ReportUtils.report((String)"trace for methods", (String)reportsPath, (String)("trace_methods_" + baseImageName), (String)"txt", writer -> writer.print(trace));
            String abortOnMethodReachableOption = SubstrateOptionsParser.commandArgument(Options.AbortOnMethodReachable, String.join((CharSequence)",", methodPatterns));
            String message = "Image building is interrupted as the methods specified via " + abortOnMethodReachableOption + " are reachable. See the generated report for a complete reachability trace: " + String.valueOf(path);
            consoleMessageBuilder.append(message);
        }
        if (!(fieldPatterns = ((LocatableMultiOptionValue.Strings)Options.AbortOnFieldReachable.getValue(options)).values()).isEmpty() && (count = ReachabilityTracePrinter.printTraceForFieldsImpl(fieldPatterns, bb, new PrintWriter(stringWriter = new StringWriter()))) > 0) {
            String trace = stringWriter.toString();
            Path path = ReportUtils.report((String)"trace for fields", (String)reportsPath, (String)("trace_fields_" + baseImageName), (String)"txt", writer -> writer.print(trace));
            String abortOnFieldReachableOption = SubstrateOptionsParser.commandArgument(Options.AbortOnFieldReachable, String.join((CharSequence)",", fieldPatterns));
            String message = "Image building is interrupted as the fields specified via " + abortOnFieldReachableOption + " are reachable. See the generated report for a complete reachability trace: " + String.valueOf(path);
            consoleMessageBuilder.append(message);
        }
        if (!consoleMessageBuilder.isEmpty()) {
            throw AnalysisError.interruptAnalysis((String)consoleMessageBuilder.toString());
        }
    }

    private static int printTraceForTypesImpl(List<String> typePatterns, BigBang bb, PrintWriter writer) {
        ObjectTreePrinter.SimpleMatcher matcher = new ObjectTreePrinter.SimpleMatcher(typePatterns.toArray(new String[0]));
        int count = 0;
        for (AnalysisType type : bb.getUniverse().getTypes()) {
            if (!type.isReachable() || !matcher.matches(type.toJavaName(true))) continue;
            if (type.isInstantiated()) {
                header = "Type " + type.toJavaName() + " is marked as instantiated";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)type.getInstantiatedReason(), (String)header);
                writer.println(trace);
            } else {
                header = "Type " + type.toJavaName() + " is marked as reachable";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)type.getReachableReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    private static int printTraceForMethodsImpl(List<String> methodPatterns, BigBang bb, PrintWriter writer) {
        MethodFilter matcher = MethodFilter.parse((String)String.join((CharSequence)",", methodPatterns));
        int count = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isReachable() || !matcher.matches((JavaMethod)method)) continue;
            if (method.isIntrinsicMethod()) {
                header = "Method " + method.format("%H.%n(%p)") + " is intrinsic";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)method.getIntrinsicMethodReason(), (String)header);
                writer.println(trace);
            } else {
                header = "Method " + method.format("%H.%n(%p)") + " is called";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)method.getParsingReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    private static int printTraceForFieldsImpl(List<String> fieldPatterns, BigBang bb, PrintWriter writer) {
        ObjectTreePrinter.SimpleMatcher matcher = new ObjectTreePrinter.SimpleMatcher(fieldPatterns.toArray(new String[0]));
        int count = 0;
        for (AnalysisField field : bb.getUniverse().getFields()) {
            if (!field.isReachable() || !matcher.matches(field.getWrapped().format("%H.%n"))) continue;
            if (field.isWritten()) {
                header = "Field " + field.getName() + " is written";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getWrittenReason(), (String)header);
                writer.println(trace);
            } else if (field.isRead()) {
                header = "Field " + field.getName() + " is read";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getReadReason(), (String)header);
                writer.println(trace);
            } else if (field.isAccessed()) {
                header = "Field " + field.getName() + " is accessed unsafely";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getAccessedReason(), (String)header);
                writer.println(trace);
            } else {
                assert (field.isFolded());
                header = "Field " + field.getName() + " is folded";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getFoldedReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> AbortOnTypeReachable = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> AbortOnMethodReachable = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> AbortOnFieldReachable = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    }
}

