/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionClassFilter;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.OptionClassFilterBuilder;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public final class LinkAtBuildTimeSupport {
    private final ClassLoaderSupport classLoaderSupport;
    private final OptionClassFilter classFilter;

    public LinkAtBuildTimeSupport(ImageClassLoader imageClassLoader, ClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
        this.classFilter = OptionClassFilterBuilder.createFilter(imageClassLoader, Options.LinkAtBuildTime, Options.LinkAtBuildTimePaths);
        this.classFilter.addPackageOrClass("jdk.internal.reflect", null);
    }

    public static LinkAtBuildTimeSupport singleton() {
        return (LinkAtBuildTimeSupport)ImageSingletons.lookup(LinkAtBuildTimeSupport.class);
    }

    public boolean linkAtBuildTime(ResolvedJavaType type) {
        return this.linkAtBuildTime(OriginalClassProvider.getJavaClass((JavaType)type));
    }

    public boolean linkAtBuildTime(Class<?> clazz) {
        return this.isIncluded(clazz) != null;
    }

    public boolean moduleLinkAtBuildTime(String module) {
        return this.classFilter.isModuleIncluded(module) != null;
    }

    public boolean packageOrClassAtBuildTime(String packageName) {
        return this.classFilter.isPackageOrClassIncluded(packageName) != null;
    }

    private Object isIncluded(Class<?> clazz) {
        if (clazz.isArray() || !this.classLoaderSupport.isNativeImageClassLoader(clazz.getClassLoader())) {
            return "system default";
        }
        assert (!clazz.isPrimitive()) : "Primitive classes are not loaded via NativeImageClassLoader";
        return this.classFilter.isIncluded(clazz);
    }

    public String errorMessageFor(ResolvedJavaType type) {
        return this.errorMessageFor(OriginalClassProvider.getJavaClass((JavaType)type));
    }

    public String errorMessageFor(Class<?> clazz) {
        assert (this.linkAtBuildTime(clazz));
        return "This error is reported at image build time because class " + clazz.getTypeName() + " is registered for linking at image build time by " + this.linkAtBuildTimeReason(clazz) + ".";
    }

    private String linkAtBuildTimeReason(Class<?> clazz) {
        Object reason = this.isIncluded(clazz);
        if (reason == null) {
            return null;
        }
        if (reason instanceof String) {
            return (String)reason;
        }
        Set origins = (Set)reason;
        return origins.stream().map(Object::toString).collect(Collectors.joining(" and "));
    }

    static final class Options {
        @APIOption(name={"link-at-build-time"}, defaultValue={""})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkAtBuildTime = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        @APIOption(name={"link-at-build-time-paths"})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkAtBuildTimePaths = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());

        Options() {
        }
    }
}

