/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ReachabilityHandler;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ConcurrentReachabilityHandler
extends ReachabilityHandler
implements InternalFeature {
    private final Map<Consumer<Feature.DuringAnalysisAccess>, AnalysisElement.ElementNotification> reachabilityNotifications = new ConcurrentHashMap<Consumer<Feature.DuringAnalysisAccess>, AnalysisElement.ElementNotification>();

    public static ConcurrentReachabilityHandler singleton() {
        return (ConcurrentReachabilityHandler)ImageSingletons.lookup(ConcurrentReachabilityHandler.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.RunReachabilityHandlersConcurrently.getValue();
    }

    @Override
    public void registerMethodOverrideReachabilityHandler(FeatureImpl.BeforeAnalysisAccessImpl access, BiConsumer<Feature.DuringAnalysisAccess, Executable> callback, Executable baseMethod) {
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        AnalysisMethod baseAnalysisMethod = metaAccess.lookupJavaMethod(baseMethod);
        AnalysisElement.MethodOverrideReachableNotification notification = new AnalysisElement.MethodOverrideReachableNotification(callback);
        baseAnalysisMethod.registerOverrideReachabilityNotification(notification);
        for (AnalysisMethod override : access.reachableMethodOverrides(baseAnalysisMethod)) {
            notification.notifyCallback(metaAccess.getUniverse(), override);
        }
    }

    @Override
    public void registerSubtypeReachabilityHandler(FeatureImpl.BeforeAnalysisAccessImpl access, BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback, Class<?> baseClass) {
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        AnalysisType baseType = metaAccess.lookupJavaType(baseClass);
        AnalysisElement.SubtypeReachableNotification notification = new AnalysisElement.SubtypeReachableNotification(callback);
        baseType.registerSubtypeReachabilityNotification(notification);
        for (AnalysisType subtype : access.reachableSubtypes(baseType)) {
            notification.notifyCallback(metaAccess.getUniverse(), subtype);
        }
    }

    @Override
    public void registerReachabilityHandler(FeatureImpl.BeforeAnalysisAccessImpl access, Consumer<Feature.DuringAnalysisAccess> callback, Object[] triggers) {
        this.registerConcurrentReachabilityHandler(access, callback, triggers);
    }

    private void registerConcurrentReachabilityHandler(FeatureImpl.BeforeAnalysisAccessImpl access, Consumer<Feature.DuringAnalysisAccess> callback, Object[] triggers) {
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        AnalysisElement.ElementNotification notification = this.reachabilityNotifications.computeIfAbsent(callback, AnalysisElement.ElementNotification::new);
        if (notification.isNotified()) {
            return;
        }
        for (Object trigger : triggers) {
            AnalysisType analysisElement;
            if (trigger instanceof Class) {
                analysisElement = metaAccess.lookupJavaType((Class)trigger);
            } else if (trigger instanceof Field) {
                analysisElement = metaAccess.lookupJavaField((Field)trigger);
            } else if (trigger instanceof Executable) {
                analysisElement = metaAccess.lookupJavaMethod((Executable)trigger);
            } else {
                throw UserError.abort("'registerReachabilityHandler' called with an element that is not a Class, Field, or Executable: %s", trigger.getClass().getTypeName());
            }
            analysisElement.registerReachabilityNotification(notification);
            if (!analysisElement.isTriggered()) continue;
            analysisElement.notifyReachabilityCallback(access.getUniverse(), notification);
        }
    }
}

