/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.CommonOptionParser;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.properties.RuntimePropertyParser;
import com.oracle.svm.core.util.ImageHeapMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeOptionParser {
    private static final String NORMAL_OPTION_PREFIX = "-XX:";
    private static final String GRAAL_OPTION_PREFIX = "-Djdk.graal.";
    private static final String LEGACY_GRAAL_OPTION_PREFIX = "-Dgraal.";
    static final String X_OPTION_PREFIX = "-X";
    public EconomicMap<String, OptionDescriptor> options = ImageHeapMap.create();

    public static String[] parseAndConsumeAllOptions(String[] initialArgs, boolean ignoreUnrecognized) {
        String[] args = initialArgs;
        if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
            args = RuntimeOptionParser.singleton().parse(args, NORMAL_OPTION_PREFIX, GRAAL_OPTION_PREFIX, LEGACY_GRAAL_OPTION_PREFIX, X_OPTION_PREFIX, ignoreUnrecognized);
            args = RuntimePropertyParser.parse(args);
        } else if (RuntimeCompilation.isEnabled() && SubstrateOptions.supportCompileInIsolates() && IsolateArgumentParser.isCompilationIsolate()) {
            args = RuntimeOptionParser.singleton().parse(args, NORMAL_OPTION_PREFIX, null, null, X_OPTION_PREFIX, ignoreUnrecognized);
        }
        return args;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addDescriptor(OptionDescriptor optionDescriptor) {
        this.options.putIfAbsent((Object)optionDescriptor.getName(), (Object)optionDescriptor);
    }

    public Optional<OptionDescriptor> getDescriptor(String optionName) {
        return Optional.ofNullable((OptionDescriptor)this.options.get((Object)optionName));
    }

    @Fold
    public static RuntimeOptionParser singleton() {
        return (RuntimeOptionParser)ImageSingletons.lookup(RuntimeOptionParser.class);
    }

    public String[] parse(String[] args, String normalOptionPrefix, String graalOptionPrefix, String legacyGraalOptionPrefix, String xOptionPrefix, boolean ignoreUnrecognized) {
        int newIdx = 0;
        EconomicMap values = OptionValues.newOptionMap();
        for (int oldIdx = 0; oldIdx < args.length; ++oldIdx) {
            String arg = args[oldIdx];
            if (arg.startsWith(normalOptionPrefix)) {
                this.parseOptionAtRuntime(arg, normalOptionPrefix, CommonOptionParser.BooleanOptionFormat.PLUS_MINUS, values, ignoreUnrecognized);
                continue;
            }
            if (graalOptionPrefix != null && arg.startsWith(graalOptionPrefix)) {
                this.parseOptionAtRuntime(arg, graalOptionPrefix, CommonOptionParser.BooleanOptionFormat.NAME_VALUE, values, ignoreUnrecognized);
                continue;
            }
            if (legacyGraalOptionPrefix != null && arg.startsWith(legacyGraalOptionPrefix)) {
                this.parseOptionAtRuntime(arg, legacyGraalOptionPrefix, CommonOptionParser.BooleanOptionFormat.NAME_VALUE, values, ignoreUnrecognized);
                continue;
            }
            if (xOptionPrefix != null && arg.startsWith(xOptionPrefix) && XOptions.parse(arg.substring(xOptionPrefix.length()), values)) continue;
            assert (newIdx <= oldIdx);
            args[newIdx] = arg;
            ++newIdx;
        }
        if (!values.isEmpty()) {
            RuntimeOptionValues.singleton().update((UnmodifiableEconomicMap)values);
        }
        if (newIdx == args.length) {
            return args;
        }
        return Arrays.copyOf(args, newIdx);
    }

    public void parseOptionAtRuntime(String arg, String optionPrefix, CommonOptionParser.BooleanOptionFormat booleanOptionFormat, EconomicMap<OptionKey<?>, Object> values, boolean ignoreUnrecognized) {
        Predicate<OptionKey<?>> isHosted = optionKey -> false;
        CommonOptionParser.OptionParseResult parseResult = SubstrateOptionsParser.parseOption(this.options, isHosted, arg.substring(optionPrefix.length()), values, optionPrefix, booleanOptionFormat);
        if (parseResult.printFlags() || parseResult.printFlagsWithExtraHelp()) {
            SubstrateOptionsParser.printFlags(d -> parseResult.matchesFlags(d, d.getOptionKey() instanceof RuntimeOptionKey), this.options, optionPrefix, Log.logStream(), parseResult.printFlagsWithExtraHelp());
            System.exit(0);
        }
        if (!parseResult.isValid()) {
            if (parseResult.optionUnrecognized() && ignoreUnrecognized) {
                return;
            }
            throw new IllegalArgumentException(parseResult.getError());
        }
        OptionKey option = parseResult.getOptionKey();
        OptionDescriptor descriptor = option.getDescriptor();
        if (descriptor != null && descriptor.isDeprecated()) {
            Log log = Log.log();
            log.string("Warning: Option '").string(descriptor.getName()).string("' is deprecated and might be removed from future versions");
            String deprecationMessage = descriptor.getDeprecationMessage();
            if (deprecationMessage != null && !deprecationMessage.isEmpty()) {
                log.string(": ").string(deprecationMessage);
            }
            log.newline();
        }
    }

    public OptionKey<?> lookupOption(String name, Collection<OptionDescriptor> fuzzyMatches) {
        OptionKey option;
        OptionDescriptor desc = (OptionDescriptor)this.options.get((Object)name);
        if (desc == null) {
            if (fuzzyMatches != null) {
                OptionsParser.collectFuzzyMatches((Iterable)this.options.getValues(), (String)name, fuzzyMatches);
            }
            option = null;
        } else {
            option = desc.getOptionKey();
        }
        return option;
    }

    public Iterable<OptionDescriptor> getDescriptors() {
        return this.options.getValues();
    }
}

