/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.layeredimagesingleton;

import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import java.util.EnumSet;

public final class LayeredImageSingletonBuilderFlags
extends Enum<LayeredImageSingletonBuilderFlags> {
    public static final /* enum */ LayeredImageSingletonBuilderFlags RUNTIME_ACCESS = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags BUILDTIME_ACCESS = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags UNSUPPORTED = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags INITIAL_LAYER_ONLY = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags ALLOW_CONSTANT_FOLDING = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags PREVENT_CONSTANT_FOLDING = new LayeredImageSingletonBuilderFlags();
    public static final EnumSet<LayeredImageSingletonBuilderFlags> BUILDTIME_ACCESS_ONLY;
    public static final EnumSet<LayeredImageSingletonBuilderFlags> RUNTIME_ACCESS_ONLY_ALLOW_FOLDING;
    public static final EnumSet<LayeredImageSingletonBuilderFlags> ALL_ACCESS_ALLOW_FOLDING;
    private static final /* synthetic */ LayeredImageSingletonBuilderFlags[] $VALUES;

    public static LayeredImageSingletonBuilderFlags[] values() {
        return (LayeredImageSingletonBuilderFlags[])$VALUES.clone();
    }

    public static LayeredImageSingletonBuilderFlags valueOf(String name) {
        return Enum.valueOf(LayeredImageSingletonBuilderFlags.class, name);
    }

    public static boolean verifyImageBuilderFlags(LayeredImageSingleton singleton) {
        EnumSet<LayeredImageSingletonBuilderFlags> flags = singleton.getImageBuilderFlags();
        if (!flags.contains((Object)UNSUPPORTED) && !flags.contains((Object)BUILDTIME_ACCESS) && !flags.contains((Object)RUNTIME_ACCESS)) assert (false) : String.format("At least one of the following flags must be set: %s, %s, %s", new Object[]{UNSUPPORTED, BUILDTIME_ACCESS, RUNTIME_ACCESS});
        if (flags.contains((Object)UNSUPPORTED)) assert (flags.equals(EnumSet.of(UNSUPPORTED))) : "Unsupported should be the only flag set " + String.valueOf(flags);
        if (flags.contains((Object)RUNTIME_ACCESS)) {
            assert (!flags.containsAll(EnumSet.of(PREVENT_CONSTANT_FOLDING, ALLOW_CONSTANT_FOLDING))) : String.format("Must set one of %s or %s. flags: %s", new Object[]{PREVENT_CONSTANT_FOLDING, ALLOW_CONSTANT_FOLDING, flags});
            assert (flags.contains((Object)PREVENT_CONSTANT_FOLDING) || flags.contains((Object)ALLOW_CONSTANT_FOLDING)) : String.format("Must set one of %s or %s. flags: %s", new Object[]{PREVENT_CONSTANT_FOLDING, ALLOW_CONSTANT_FOLDING, flags});
        }
        if (flags.contains((Object)BUILDTIME_ACCESS) && !flags.contains((Object)RUNTIME_ACCESS)) assert (!flags.contains((Object)PREVENT_CONSTANT_FOLDING) && !flags.contains((Object)ALLOW_CONSTANT_FOLDING)) : "Constant folding is only applicable for runtime accesses " + String.valueOf(flags);
        return true;
    }

    private static /* synthetic */ LayeredImageSingletonBuilderFlags[] $values() {
        return new LayeredImageSingletonBuilderFlags[]{RUNTIME_ACCESS, BUILDTIME_ACCESS, UNSUPPORTED, INITIAL_LAYER_ONLY, ALLOW_CONSTANT_FOLDING, PREVENT_CONSTANT_FOLDING};
    }

    static {
        $VALUES = LayeredImageSingletonBuilderFlags.$values();
        BUILDTIME_ACCESS_ONLY = EnumSet.of(BUILDTIME_ACCESS);
        RUNTIME_ACCESS_ONLY_ALLOW_FOLDING = EnumSet.of(RUNTIME_ACCESS, ALLOW_CONSTANT_FOLDING);
        ALL_ACCESS_ALLOW_FOLDING = EnumSet.of(RUNTIME_ACCESS, BUILDTIME_ACCESS, ALLOW_CONSTANT_FOLDING);
    }
}

