/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerSampleWriterDataAccess;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrStackWalker {
    public static final int NO_ERROR = 0;
    public static final int TRUNCATED = 1;
    public static final int UNPARSEABLE_STACK = 2;
    public static final int BUFFER_SIZE_EXCEEDED = 3;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrStackWalker() {
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    public static void walkCurrentThread(CodePointer initialIP, Pointer initialSP, boolean isAsync) {
        SamplerSampleWriterData data = UnsafeStackValue.get(SamplerSampleWriterData.class);
        if (SamplerSampleWriterDataAccess.initialize(data, 0, false)) {
            SamplerSampleWriter.begin(data);
            int result = JfrStackWalker.walkCurrentThread(data, initialIP, initialSP, isAsync);
            switch (result) {
                case 0: 
                case 1: {
                    SamplerSampleWriter.end(data, -2L);
                    break;
                }
                case 2: {
                    VMError.guarantee(isAsync, "Only the async sampler may encounter an unparseable stack.");
                    JfrThreadLocal.increaseUnparseableStacks();
                    break;
                }
                case 3: {
                    JfrThreadLocal.increaseMissedSamples();
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere("Unexpected return value");
                }
            }
        }
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    public static int walkCurrentThread(SamplerSampleWriterData data, CodePointer topFrameIP, Pointer topFrameSP, boolean isAsync) {
        CodePointer ip = topFrameIP;
        Pointer sp = topFrameSP;
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
        if (isAsync) {
            if (VMThreads.SafepointBehavior.isCrashedThread(CurrentIsolate.getCurrentThread())) {
                return 2;
            }
            CodeInfo codeInfo = CodeInfoTable.lookupImageCodeInfo(ip);
            if (codeInfo.isNonNull()) {
                int result = JfrStackWalker.recordIp(data, ip);
                if (result != 0) {
                    return result;
                }
                anchor = JfrStackWalker.filterTopFrameAnchorIfIncomplete(anchor);
                long topFrameEncodedSize = CodeInfoAccess.lookupEncodedFrameSize(codeInfo, ip);
                boolean topFrameIsEntryPoint = CodeInfoQueryResult.isEntryPoint(topFrameEncodedSize);
                if (topFrameIsEntryPoint) {
                    if (anchor.isNull()) {
                        return 2;
                    }
                    sp = anchor.getLastJavaSP();
                    ip = anchor.getLastJavaIP();
                    anchor = anchor.getPreviousAnchor();
                } else {
                    if (JfrStackWalker.isSPAligned(sp)) {
                        UnsignedWord topFrameSize = WordFactory.unsigned((long)CodeInfoQueryResult.getTotalFrameSize(topFrameEncodedSize));
                        sp = SubstrateOptions.hasFramePointer() && !JfrStackWalker.hasValidCaller(sp, topFrameSize, topFrameIsEntryPoint, anchor) ? sp.add(FrameAccess.wordSize() * 2) : sp.add(topFrameSize);
                    } else {
                        sp = sp.add(FrameAccess.wordSize());
                    }
                    assert (JfrStackWalker.isSPAligned(sp));
                    if (!JfrStackWalker.isCallerSPValid(topFrameSP, sp)) {
                        return 2;
                    }
                    ip = FrameAccess.singleton().unsafeReadReturnAddress(sp);
                }
            } else {
                if (anchor.isNull()) {
                    return 2;
                }
                ip = anchor.getLastJavaIP();
                sp = anchor.getLastJavaSP();
                anchor = anchor.getPreviousAnchor();
            }
            if (!JfrStackWalker.isCallerValid(topFrameSP, sp, ip)) {
                return 2;
            }
        }
        return JfrStackWalker.walkCurrentThread0(data, sp, ip, anchor, isAsync);
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    private static int walkCurrentThread0(SamplerSampleWriterData data, Pointer startSP, CodePointer startIP, JavaFrameAnchor anchor, boolean isAsync) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        JavaStackWalk walk = (JavaStackWalk)UnsafeStackValue.get(JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initialize(walk, thread, startSP, startIP, anchor);
        assert (JavaStackWalker.getEndSP(walk).isNull()) : "not supported by the code below";
        while (JavaStackWalker.advance(walk, thread)) {
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            VMError.guarantee(Deoptimizer.checkDeoptimized(frame) == null, "JIT compilation is not supported");
            if (JavaFrames.isUnknownFrame(frame) || isAsync && !JfrStackWalker.hasValidCaller(walk, frame)) {
                return 2;
            }
            int result = JfrStackWalker.recordIp(data, frame.getIP());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    private static int recordIp(SamplerSampleWriterData data, CodePointer ip) {
        assert (data.isNonNull());
        data.setSeenFrames(data.getSeenFrames() + 1);
        if (JfrStackWalker.shouldSkipFrame(data)) {
            return 0;
        }
        if (JfrStackWalker.shouldTruncate(data)) {
            return 1;
        }
        boolean success = SamplerSampleWriter.putLong(data, ip.rawValue());
        if (success) {
            int newHash = JfrStackWalker.computeHash(data.getHashCode(), ip.rawValue());
            data.setHashCode(newHash);
            return 0;
        }
        return 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean shouldSkipFrame(SamplerSampleWriterData data) {
        return data.getSeenFrames() <= data.getSkipCount();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean shouldTruncate(SamplerSampleWriterData data) {
        int numFrames = data.getSeenFrames() - data.getSkipCount();
        if (numFrames > data.getMaxDepth()) {
            data.setTruncated(true);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int computeHash(int oldHash, long ip) {
        int hash = (int)(ip ^ ip >>> 32);
        return 31 * oldHash + hash;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JavaFrameAnchor filterTopFrameAnchorIfIncomplete(JavaFrameAnchor anchor) {
        if (anchor.isNonNull() && (anchor.getLastJavaSP().isNull() || anchor.getLastJavaIP().isNull())) {
            return anchor.getPreviousAnchor();
        }
        return anchor;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean hasValidCaller(JavaStackWalk walk, JavaFrame frame) {
        return JfrStackWalker.hasValidCaller(frame.getSP(), JavaFrames.getTotalFrameSize(frame), JavaFrames.isEntryPoint(frame), JavaStackWalker.getFrameAnchor(walk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean hasValidCaller(Pointer currentSP, UnsignedWord currentFrameSize, boolean currentFrameIsEntryPoint, JavaFrameAnchor anchor) {
        if (currentFrameIsEntryPoint) {
            return anchor.isNull() || anchor.getLastJavaSP().aboveThan((UnsignedWord)currentSP) && CodeInfoTable.isInAOTImageCode(anchor.getLastJavaIP());
        }
        Pointer callerSP = currentSP.add(currentFrameSize);
        if (!JfrStackWalker.isCallerSPValid(currentSP, callerSP)) {
            return false;
        }
        CodePointer ip = FrameAccess.singleton().unsafeReadReturnAddress(callerSP);
        return CodeInfoTable.isInAOTImageCode(ip);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isCallerSPValid(Pointer currentSP, Pointer callerSP) {
        UnsignedWord stackEnd = VMThreads.StackEnd.get();
        UnsignedWord stackBase = VMThreads.StackBase.get();
        if (stackEnd.equal(0) || stackBase.equal(0)) {
            return false;
        }
        assert (stackEnd.belowThan(stackBase));
        assert (stackEnd.belowOrEqual((UnsignedWord)currentSP));
        assert (stackBase.aboveThan((UnsignedWord)currentSP));
        if (JfrStackWalker.isSPAligned(callerSP) && callerSP.aboveThan((UnsignedWord)currentSP) && callerSP.belowThan(stackBase)) {
            Pointer returnAddressLocation = FrameAccess.singleton().unsafeReturnAddressLocation(callerSP);
            return returnAddressLocation.aboveOrEqual((UnsignedWord)currentSP) && returnAddressLocation.belowThan(stackBase);
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isSPAligned(Pointer sp) {
        return PointerUtils.isAMultiple((PointerBase)sp, WordFactory.unsigned((int)ConfigurationValues.getTarget().stackAlignment));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isCallerValid(Pointer currentSP, Pointer callerSP, CodePointer callerIP) {
        return CodeInfoTable.isInAOTImageCode(callerIP) && JfrStackWalker.isCallerSPValid(currentSP, callerSP);
    }
}

