/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.jdk.localization.substitutions.modes.OptimizedLocaleMode;
import com.oracle.svm.core.jdk.resources.MissingResourceRegistrationUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.internal.loader.BootLoader;
import org.graalvm.nativeimage.ImageSingletons;
import sun.security.util.SecurityConstants;

@TargetClass(value=ResourceBundle.class)
final class Target_java_util_ResourceBundle {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static ConcurrentMap<?, ?> cacheList = new ConcurrentHashMap();

    Target_java_util_ResourceBundle() {
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, Locale.getDefault());
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, Locale.getDefault());
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale locale) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, locale);
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, targetLocale);
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, locale);
    }

    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, targetLocale);
    }

    @Substitute
    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    private static ResourceBundle getBundle(String baseName, Module module) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, Locale.getDefault());
    }

    @Substitute
    @TargetElement(onlyWith={OptimizedLocaleMode.class})
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, Module module) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).asOptimizedSupport().getCached(baseName, targetLocale);
    }

    @Substitute
    private static ResourceBundle getBundleImpl(String baseName, Locale locale, Class<?> caller, ClassLoader loader, ResourceBundle.Control control) {
        Module unnamedModule;
        Module callerModule = Target_java_util_ResourceBundle.getCallerModule(caller);
        if (callerModule.isNamed() && loader == Target_java_util_ResourceBundle.getLoader(callerModule)) {
            if (!((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).isRegisteredBundleLookup(baseName, locale, control)) {
                MissingResourceRegistrationUtils.missingResourceBundle(baseName);
            }
            return Target_java_util_ResourceBundle.getBundleImpl(callerModule, callerModule, baseName, locale, control);
        }
        Module module = unnamedModule = loader != null ? loader.getUnnamedModule() : BootLoader.getUnnamedModule();
        if (!((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).isRegisteredBundleLookup(baseName, locale, control)) {
            MissingResourceRegistrationUtils.missingResourceBundle(baseName);
        }
        return Target_java_util_ResourceBundle.getBundleImpl(callerModule, unnamedModule, baseName, locale, control);
    }

    @Substitute
    private static ResourceBundle getBundleFromModule(Class<?> caller, Module module, String baseName, Locale locale, ResourceBundle.Control control) {
        SecurityManager sm;
        Objects.requireNonNull(module);
        Module callerModule = Target_java_util_ResourceBundle.getCallerModule(caller);
        if (callerModule != module && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        if (!((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).isRegisteredBundleLookup(baseName, locale, control)) {
            MissingResourceRegistrationUtils.missingResourceBundle(baseName);
        }
        return Target_java_util_ResourceBundle.getBundleImpl(callerModule, module, baseName, locale, control);
    }

    @Alias
    private static native Module getCallerModule(Class<?> var0);

    @Alias
    private static native ClassLoader getLoader(Module var0);

    @Alias
    private static native ResourceBundle getBundleImpl(Module var0, Module var1, String var2, Locale var3, ResourceBundle.Control var4);
}

