/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.dump.HProfType;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.coder.ByteStream;
import com.oracle.svm.core.util.coder.ByteStreamAccess;
import com.oracle.svm.core.util.coder.NativeCoder;
import com.oracle.svm.core.util.coder.Pack200Coder;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class HeapDumpMetadata {
    private final ComputeHubDataVisitor computeHubDataVisitor = new ComputeHubDataVisitor();
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private byte[] data;
    private int fieldNameCount;
    private int classInfoCount;
    private ClassInfo classInfos;
    private FieldInfoPointer fieldInfoTable;
    private FieldNamePointer fieldNameTable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapDumpMetadata() {
    }

    @Fold
    public static HeapDumpMetadata singleton() {
        return (HeapDumpMetadata)ImageSingletons.lookup(HeapDumpMetadata.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(byte[] value) {
        this.data = value;
    }

    public boolean initialize() {
        int i;
        assert (this.classInfos.isNull() && this.fieldInfoTable.isNull() && this.fieldNameTable.isNull());
        Object start = NonmovableArrays.getArrayBase(NonmovableArrays.fromImageHeap((Object)this.data));
        Pointer end = start.add(this.data.length);
        ByteStream stream = (ByteStream)StackValue.get(ByteStream.class);
        ByteStreamAccess.initialize(stream, start);
        int totalFieldCount = NativeCoder.readInt(stream);
        int classCount = NativeCoder.readInt(stream);
        this.fieldNameCount = NativeCoder.readInt(stream);
        int maxTypeId = Pack200Coder.readUVAsInt(stream);
        this.classInfoCount = maxTypeId + 1;
        UnsignedWord classInfosSize = WordFactory.unsigned((int)this.classInfoCount).multiply(SizeOf.get(ClassInfo.class));
        this.classInfos = (ClassInfo)NullableNativeMemory.calloc(classInfosSize, NmtCategory.HeapDump);
        if (this.classInfos.isNull()) {
            return false;
        }
        UnsignedWord fieldStartsSize = WordFactory.unsigned((int)totalFieldCount).multiply(SizeOf.get(FieldInfoPointer.class));
        this.fieldInfoTable = (FieldInfoPointer)NullableNativeMemory.calloc(fieldStartsSize, NmtCategory.HeapDump);
        if (this.fieldInfoTable.isNull()) {
            return false;
        }
        UnsignedWord fieldNameTableSize = WordFactory.unsigned((int)this.fieldNameCount).multiply(SizeOf.get(FieldNamePointer.class));
        this.fieldNameTable = (FieldNamePointer)NullableNativeMemory.calloc(fieldNameTableSize, NmtCategory.HeapDump);
        if (this.fieldNameTable.isNull()) {
            return false;
        }
        int fieldIndex = 0;
        for (i = 0; i < classCount; ++i) {
            Pointer fieldInfo;
            int j;
            int typeId = Pack200Coder.readUVAsInt(stream);
            ClassInfo classInfo = this.getClassInfo(typeId);
            int numInstanceFields = Pack200Coder.readUVAsInt(stream);
            classInfo.setInstanceFieldCount(numInstanceFields);
            int numStaticFields = Pack200Coder.readUVAsInt(stream);
            classInfo.setStaticFieldCount(numStaticFields);
            classInfo.setInstanceFields(this.fieldInfoTable.addressOf(fieldIndex));
            for (j = 0; j < numInstanceFields; ++j) {
                fieldInfo = (Pointer)this.fieldInfoTable.addressOf(fieldIndex);
                fieldInfo.writeWord(0, (WordBase)stream.getPosition());
                FieldInfoAccess.skipFieldInfo(stream);
                ++fieldIndex;
            }
            classInfo.setStaticFields(this.fieldInfoTable.addressOf(fieldIndex));
            for (j = 0; j < numStaticFields; ++j) {
                fieldInfo = (Pointer)this.fieldInfoTable.addressOf(fieldIndex);
                fieldInfo.writeWord(0, (WordBase)stream.getPosition());
                FieldInfoAccess.skipFieldInfo(stream);
                ++fieldIndex;
            }
        }
        for (i = 0; i < this.fieldNameCount; ++i) {
            Pointer fieldName = (Pointer)this.fieldNameTable.addressOf(i);
            fieldName.writeWord(0, (WordBase)stream.getPosition());
            int length = Pack200Coder.readUVAsInt(stream);
            stream.setPosition(stream.getPosition().add(length));
        }
        assert (stream.getPosition().equal((UnsignedWord)end));
        this.computeHubDataVisitor.initialize();
        Heap.getHeap().walkImageHeapObjects(this.computeHubDataVisitor);
        for (i = 0; i < this.classInfoCount; ++i) {
            ClassInfo classInfo = this.getClassInfo(i);
            if (!ClassInfoAccess.isValid(classInfo)) continue;
            this.computeInstanceFieldsDumpSize(classInfo);
        }
        return true;
    }

    public void teardown() {
        NullableNativeMemory.free(this.classInfos);
        this.classInfos = (ClassInfo)WordFactory.nullPointer();
        NullableNativeMemory.free(this.fieldInfoTable);
        this.fieldInfoTable = (FieldInfoPointer)WordFactory.nullPointer();
        NullableNativeMemory.free(this.fieldNameTable);
        this.fieldNameTable = (FieldNamePointer)WordFactory.nullPointer();
    }

    public int getClassInfoCount() {
        return this.classInfoCount;
    }

    public ClassInfo getClassInfo(Class<?> clazz) {
        if (clazz == null) {
            return (ClassInfo)WordFactory.nullPointer();
        }
        return this.getClassInfo(DynamicHub.fromClass(clazz));
    }

    public ClassInfo getClassInfo(DynamicHub hub) {
        if (hub == null) {
            return (ClassInfo)WordFactory.nullPointer();
        }
        return this.getClassInfo(hub.getTypeID());
    }

    public ClassInfo getClassInfo(int typeId) {
        return this.classInfos.addressOf(typeId);
    }

    public int getFieldNameCount() {
        return this.fieldNameCount;
    }

    public FieldName getFieldName(int index) {
        return this.fieldNameTable.addressOf(index).read();
    }

    private int computeInstanceFieldsDumpSize(ClassInfo classInfo) {
        if (classInfo.getInstanceFieldsDumpSize() != -1) {
            return classInfo.getInstanceFieldsDumpSize();
        }
        int result = HeapDumpMetadata.computeFieldsDumpSize(classInfo.getInstanceFields(), classInfo.getInstanceFieldCount());
        DynamicHub superHub = classInfo.getHub().getSuperHub();
        if (superHub != null) {
            result += this.computeInstanceFieldsDumpSize(this.getClassInfo(superHub));
        }
        classInfo.setInstanceFieldsDumpSize(result);
        return result;
    }

    static int computeFieldsDumpSize(FieldInfoPointer fields, int fieldCount) {
        int result = 0;
        for (int i = 0; i < fieldCount; ++i) {
            FieldInfo field = fields.addressOf(i).read();
            HProfType type = FieldInfoAccess.getType(field);
            result += type.getSize();
        }
        return result;
    }

    private static class ComputeHubDataVisitor
    implements ObjectVisitor {
        private int classSerialNum;

        private ComputeHubDataVisitor() {
        }

        public void initialize() {
            this.classSerialNum = 0;
        }

        @Override
        public boolean visitObject(Object o) {
            if (o instanceof DynamicHub) {
                DynamicHub hub = (DynamicHub)o;
                ClassInfo classInfo = HeapDumpMetadata.singleton().getClassInfo(hub.getTypeID());
                assert (classInfo.getHub() == null);
                classInfo.setHub(hub);
                classInfo.setSerialNum(++this.classSerialNum);
                classInfo.setInstanceFieldsDumpSize(-1);
            }
            return true;
        }
    }

    @RawStructure
    public static interface ClassInfo
    extends PointerBase {
        @RawField
        @PinnedObjectField
        public DynamicHub getHub();

        @RawField
        @PinnedObjectField
        public void setHub(DynamicHub var1);

        @RawField
        public int getSerialNum();

        @RawField
        public void setSerialNum(int var1);

        @RawField
        public int getInstanceFieldsDumpSize();

        @RawField
        public void setInstanceFieldsDumpSize(int var1);

        @RawField
        public int getInstanceFieldCount();

        @RawField
        public void setInstanceFieldCount(int var1);

        @RawField
        public FieldInfoPointer getInstanceFields();

        @RawField
        public void setInstanceFields(FieldInfoPointer var1);

        @RawField
        public int getStaticFieldCount();

        @RawField
        public void setStaticFieldCount(int var1);

        @RawField
        public FieldInfoPointer getStaticFields();

        @RawField
        public void setStaticFields(FieldInfoPointer var1);

        public ClassInfo addressOf(int var1);
    }

    @RawPointerTo(value=FieldInfo.class)
    public static interface FieldInfoPointer
    extends PointerBase {
        public FieldInfoPointer addressOf(int var1);

        public FieldInfo read();
    }

    @RawPointerTo(value=FieldName.class)
    public static interface FieldNamePointer
    extends PointerBase {
        public FieldNamePointer addressOf(int var1);

        public FieldName read();
    }

    public static class FieldInfoAccess {
        static HProfType getType(FieldInfo field) {
            return HProfType.get(((Pointer)field).readByte(0));
        }

        static FieldName getFieldName(FieldInfo field) {
            int fieldNameIndex = Pack200Coder.readUVAsInt(FieldInfoAccess.getFieldNameIndexAddress(field));
            return HeapDumpMetadata.singleton().getFieldName(fieldNameIndex);
        }

        static int getLocation(FieldInfo field) {
            Pointer fieldNameIndex = FieldInfoAccess.getFieldNameIndexAddress(field);
            ByteStream stream = (ByteStream)StackValue.get(ByteStream.class);
            ByteStreamAccess.initialize(stream, fieldNameIndex);
            Pack200Coder.readUVAsInt(stream);
            return Pack200Coder.readUVAsInt(stream);
        }

        static void skipFieldInfo(ByteStream stream) {
            NativeCoder.readByte(stream);
            Pack200Coder.readUVAsInt(stream);
            Pack200Coder.readUVAsInt(stream);
        }

        private static Pointer getFieldNameIndexAddress(FieldInfo field) {
            return ((Pointer)field).add(1);
        }
    }

    public static class ClassInfoAccess {
        static boolean isValid(ClassInfo classInfo) {
            return classInfo.getHub() != null;
        }
    }

    @RawStructure
    public static interface FieldName
    extends PointerBase {
    }

    @RawStructure
    public static interface FieldInfo
    extends PointerBase {
    }

    public static class FieldNameAccess {
        static int getLength(FieldName fieldName) {
            return Pack200Coder.readUVAsInt((Pointer)fieldName);
        }

        static CCharPointer getChars(FieldName fieldName) {
            ByteStream data = (ByteStream)StackValue.get(ByteStream.class);
            ByteStreamAccess.initialize(data, (Pointer)fieldName);
            Pack200Coder.readUV(data);
            return (CCharPointer)data.getPosition();
        }
    }
}

