/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.Pointer;

public interface ObjectReferenceVisitor {
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Some implementations allocate.")
    public boolean visitObjectReference(Pointer var1, boolean var2, Object var3);

    @AlwaysInline(value="GC performance")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Some implementations allocate.")
    default public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed, Object holderObject) {
        VMError.guarantee(innerOffset == 0, "visitor does not support derived references");
        return this.visitObjectReference(objRef, compressed, holderObject);
    }
}

