/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.UnsignedWord;

public class ImageCodeInfo {
    public static final String CODE_INFO_NAME = "image code";
    private final CIsolateData<CodeInfoImpl> runtimeCodeInfo = CIsolateDataFactory.createStruct("runtimeCodeInfo", CodeInfoImpl.class);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final HostedImageCodeInfo hostedImageCodeInfo = new HostedImageCodeInfo();
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private CodePointer codeStart;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord entryPointOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord codeSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord dataOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord dataSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord codeAndDataMemorySize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private int methodTableFirstId;
    private final Object[] objectFields;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] codeInfoIndex;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] codeInfoEncodings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] referenceMapEncoding;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] frameInfoEncodings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    Object[] objectConstants;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    Class<?>[] classes;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    String[] memberNames;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    String[] otherStrings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] methodTable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ImageCodeInfo() {
        NonmovableObjectArray objfields = NonmovableArrays.createObjectArray(Object[].class, 3, NmtCategory.Code);
        NonmovableArrays.setObject(objfields, 1, CODE_INFO_NAME);
        NonmovableArrays.setObject(objfields, 0, new CodeInfoTether(true));
        this.objectFields = (Object[])NonmovableArrays.getHostedArray(objfields);
    }

    @Uninterruptible(reason="Executes during isolate creation.")
    CodeInfo prepareCodeInfo() {
        CodeInfoImpl info = this.runtimeCodeInfo.get();
        assert (info.getCodeStart().isNull()) : "already initialized";
        info.setObjectFields(NonmovableArrays.fromImageHeap(this.objectFields));
        info.setCodeStart(this.codeStart);
        info.setCodeSize(this.codeSize);
        info.setDataOffset(this.dataOffset);
        info.setDataSize(this.dataSize);
        info.setCodeAndDataMemorySize(this.codeAndDataMemorySize);
        info.setCodeInfoIndex(NonmovableArrays.fromImageHeap((Object)this.codeInfoIndex));
        info.setCodeInfoEncodings(NonmovableArrays.fromImageHeap((Object)this.codeInfoEncodings));
        info.setStackReferenceMapEncoding(NonmovableArrays.fromImageHeap((Object)this.referenceMapEncoding));
        info.setFrameInfoEncodings(NonmovableArrays.fromImageHeap((Object)this.frameInfoEncodings));
        info.setObjectConstants(NonmovableArrays.fromImageHeap(this.objectConstants));
        info.setClasses(NonmovableArrays.fromImageHeap(this.classes));
        info.setMemberNames(NonmovableArrays.fromImageHeap(this.memberNames));
        info.setOtherStrings(NonmovableArrays.fromImageHeap(this.otherStrings));
        info.setMethodTable(NonmovableArrays.fromImageHeap((Object)this.methodTable));
        info.setMethodTableFirstId(this.methodTableFirstId);
        info.setIsAOTImageCode(true);
        return info;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer getCodeStart() {
        return this.codeStart;
    }

    public HostedImageCodeInfo getHostedImageCodeInfo() {
        return this.hostedImageCodeInfo;
    }

    public List<Integer> getTotalByteArrayLengths() {
        return List.of(Integer.valueOf(this.codeInfoIndex.length), Integer.valueOf(this.codeInfoEncodings.length), Integer.valueOf(this.referenceMapEncoding.length), Integer.valueOf(this.frameInfoEncodings.length), Integer.valueOf(this.methodTable.length));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public class HostedImageCodeInfo
    implements CodeInfoImpl {
        @Override
        public CodePointer getCodeStart() {
            return ImageCodeInfo.this.codeStart;
        }

        @Override
        public UnsignedWord getCodeSize() {
            return ImageCodeInfo.this.codeSize;
        }

        @Override
        public UnsignedWord getDataOffset() {
            return ImageCodeInfo.this.dataOffset;
        }

        @Override
        public UnsignedWord getDataSize() {
            return ImageCodeInfo.this.dataSize;
        }

        @Override
        public UnsignedWord getCodeAndDataMemorySize() {
            return ImageCodeInfo.this.codeAndDataMemorySize;
        }

        @Override
        public NonmovableArray<Byte> getStackReferenceMapEncoding() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.referenceMapEncoding);
        }

        @Override
        public void setCodeStart(CodePointer value) {
            ImageCodeInfo.this.codeStart = value;
        }

        @Override
        public UnsignedWord getCodeEntryPointOffset() {
            return ImageCodeInfo.this.entryPointOffset;
        }

        @Override
        public void setCodeSize(UnsignedWord value) {
            ImageCodeInfo.this.codeSize = value;
        }

        @Override
        public void setCodeEntryPointOffset(UnsignedWord offset) {
            ImageCodeInfo.this.entryPointOffset = offset;
        }

        @Override
        public void setDataOffset(UnsignedWord value) {
            ImageCodeInfo.this.dataOffset = value;
        }

        @Override
        public void setDataSize(UnsignedWord value) {
            ImageCodeInfo.this.dataSize = value;
        }

        @Override
        public void setCodeAndDataMemorySize(UnsignedWord value) {
            ImageCodeInfo.this.codeAndDataMemorySize = value;
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoIndex() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoIndex);
        }

        @Override
        public void setCodeInfoIndex(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoIndex = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoEncodings);
        }

        @Override
        public void setCodeInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public void setStackReferenceMapEncoding(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.referenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getFrameInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.frameInfoEncodings);
        }

        @Override
        public void setFrameInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.frameInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Object> getObjectConstants() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.objectConstants);
        }

        @Override
        public void setObjectConstants(NonmovableObjectArray<Object> array) {
            ImageCodeInfo.this.objectConstants = (Object[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Class<?>> getClasses() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.classes);
        }

        @Override
        public void setClasses(NonmovableObjectArray<Class<?>> array) {
            ImageCodeInfo.this.classes = (Class[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<String> getMemberNames() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.memberNames);
        }

        @Override
        public void setMemberNames(NonmovableObjectArray<String> array) {
            ImageCodeInfo.this.memberNames = (String[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<String> getOtherStrings() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.otherStrings);
        }

        @Override
        public void setOtherStrings(NonmovableObjectArray<String> array) {
            ImageCodeInfo.this.otherStrings = (String[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getMethodTable() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.methodTable);
        }

        @Override
        public void setMethodTable(NonmovableArray<Byte> methods) {
            ImageCodeInfo.this.methodTable = (byte[])NonmovableArrays.getHostedArray(methods);
        }

        @Override
        public int getMethodTableFirstId() {
            return ImageCodeInfo.this.methodTableFirstId;
        }

        @Override
        public void setMethodTableFirstId(int methodId) {
            ImageCodeInfo.this.methodTableFirstId = methodId;
        }

        @Override
        public void setObjectFields(NonmovableObjectArray<Object> fields) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getObjectFields() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getTier() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setTier(int tier) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getState() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setState(int state) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getCodeConstantsReferenceMapEncoding() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapEncoding(NonmovableArray<Byte> objectsReferenceMapEncoding) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public long getCodeConstantsReferenceMapIndex() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapIndex(long objectsReferenceMapIndex) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Integer> getDeoptimizationStartOffsets() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationStartOffsets(NonmovableArray<Integer> deoptimizationStartOffsets) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getDeoptimizationEncodings() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationEncodings(NonmovableArray<Byte> deoptimizationEncodings) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getDeoptimizationObjectConstants() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationObjectConstants(NonmovableObjectArray<Object> deoptimizationObjectConstants) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> getCodeObserverHandles() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeObserverHandles(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> handles) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public Word getGCData() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setAllObjectsAreInImageHeap(boolean value) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public boolean getAllObjectsAreInImageHeap() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setIsAOTImageCode(boolean value) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public boolean getIsAOTImageCode() {
            return true;
        }

        @Override
        public void setNextImageCodeInfo(CodeInfo next) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        @Override
        public CodeInfo getNextImageCodeInfo() {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public boolean isNull() {
            return false;
        }

        public boolean isNonNull() {
            return !this.isNull();
        }

        public boolean equal(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public boolean notEqual(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public long rawValue() {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }
    }
}

