/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.lir.DeoptEntryOp;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.nodes.FrameState;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;

class Instance {
    private StringBuilder errors;

    Instance() {
    }

    public void run(LIRGenerationResult lirGenRes) {
        LIR ir = lirGenRes.getLIR();
        DebugContext debug = ir.getDebug();
        FrameMap frameMap = lirGenRes.getFrameMap();
        for (int bockId : ir.linearScanOrder()) {
            if (LIR.isBlockDeleted((int)bockId)) continue;
            BasicBlock block = ir.getControlFlowGraph().getBlocks()[bockId];
            for (LIRInstruction op : ir.getLIRforBlock(block)) {
                op.forEachState((instruction, state) -> this.doState(debug, frameMap, instruction, state));
            }
        }
        if (this.errors != null) {
            throw VMError.shouldNotReachHere(this.errors.toString());
        }
    }

    private void reportError(LIRFrameState state, LIRInstruction op, String message) {
        if (this.errors == null) {
            this.errors = new StringBuilder();
            this.errors.append("\nProblems found within VerifyDeoptLIRFrameStatesPhase\n");
        }
        this.errors.append("\nProblem: ").append(message);
        BytecodeFrame frame = state.topFrame;
        while (frame.caller() != null) {
            frame = frame.caller();
        }
        this.errors.append("\nMethod: ").append(frame.getMethod());
        this.errors.append("\nop id: ").append(op.id()).append(", ").append(op);
        frame = state.topFrame;
        do {
            this.errors.append("\nat: bci ").append(frame.getBCI()).append(", duringCall: ").append(frame.duringCall).append(", rethrowException: ").append(frame.rethrowException).append(", method: ").append(frame.getMethod());
        } while ((frame = frame.caller()) != null);
        this.errors.append("\nEnd Problem\n");
    }

    private static boolean isImplicitDeoptEntry(LIRFrameState state) {
        BytecodeFrame frame = state.topFrame;
        if (frame.duringCall) {
            return state.validForDeoptimization && ((HostedMethod)frame.getMethod()).compilationInfo.isDeoptEntry(frame.getBCI(), FrameState.StackState.of((BytecodeFrame)frame));
        }
        return false;
    }

    private void doState(DebugContext debug, FrameMap frameMap, LIRInstruction op, LIRFrameState state) {
        if (op instanceof DeoptEntryOp || Instance.isImplicitDeoptEntry(state)) {
            SubstrateReferenceMap refMap = (SubstrateReferenceMap)state.debugInfo().getReferenceMap();
            Map<Integer, Object> refMapRegisters = refMap.getDebugAllUsedRegisters();
            Map<Integer, Object> refMapStackSlots = refMap.getDebugAllUsedStackSlots();
            if (refMapRegisters != null && !refMapRegisters.isEmpty()) {
                this.reportError(state, op, "Deoptimization target must not use any registers");
            }
            if (refMapStackSlots != null) {
                HashMap<Integer, Object> missingStackSlots = new HashMap<Integer, Object>(refMapStackSlots);
                BytecodeFrame frame = state.topFrame;
                do {
                    for (JavaValue v : frame.values) {
                        JavaValue value = v;
                        if (value instanceof StackLockValue) {
                            StackLockValue lock = (StackLockValue)value;
                            assert (ValueUtil.isIllegal((Value)lock.getSlot()));
                            value = lock.getOwner();
                        }
                        if (value instanceof StackSlot) {
                            StackSlot stackSlot = (StackSlot)value;
                            int offset = stackSlot.getOffset(frameMap.totalFrameSize());
                            debug.log("remove slot %d: %s", offset, (Object)stackSlot);
                            missingStackSlots.remove(offset);
                            continue;
                        }
                        if (ValueUtil.isConstantJavaValue((JavaValue)value) || ValueUtil.isIllegalJavaValue((JavaValue)value) || ReservedRegisters.singleton().isAllowedInFrameState(value)) continue;
                        this.reportError(state, op, "unknown value in deopt target: " + String.valueOf(value));
                    }
                } while ((frame = frame.caller()) != null);
                if (!missingStackSlots.isEmpty()) {
                    this.reportError(state, op, "LIRFrameState is missing live stack slot values: " + String.valueOf(missingStackSlots));
                }
            }
        }
    }
}

